/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.client.ftp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FTPTestClient {
    private static final int TIMEOUT = 5000;
    private FTPClient client = null;
    private String server = null;
    private int port;
    private String user = null;
    private String password = null;

    public FTPTestClient(String server, int port, String user, String password) {
        this.server = server;
        this.port = port;
        this.user = user;
        this.password = password;
        this.client = new FTPClient();
    }

    public boolean testConnection() throws IOException {
        this.connect();
        return this.verifyStatusCode(this.client.noop());
    }

    public String[] getFileList(String path) throws IOException {
        this.connect();
        return this.client.listNames(path);
    }

    public String getWorkingDirectory() throws IOException {
        return this.client.printWorkingDirectory();
    }

    public boolean makeDir(String dir) throws IOException {
        this.connect();
        return this.verifyStatusCode(this.client.mkd(dir));
    }

    public FTPFile get(String path) throws IOException {
        FTPFile[] files = this.client.listFiles(path);
        if (files == null && files.length == 0) {
            throw new RuntimeException("Could not find file " + path);
        }
        if (files.length > 1) {
            throw new RuntimeException("Too many matches for path " + path);
        }
        return files[0];
    }

    private boolean verifyStatusCode(int status) {
        return status >= 200 && status < 300;
    }

    public boolean putFile(String path, String content) throws IOException {
        return this.putFile(path, content.getBytes());
    }

    public boolean putFile(String path, byte[] content) throws IOException {
        this.connect();
        return this.client.storeFile(path, (InputStream)new ByteArrayInputStream(content));
    }

    public boolean dirExists(String path) throws IOException {
        this.connect();
        String cwd = this.client.printWorkingDirectory();
        boolean dirExists = this.client.changeWorkingDirectory(path);
        this.client.changeWorkingDirectory(cwd);
        return dirExists;
    }

    protected void connect() throws IOException {
        if (!this.client.isConnected()) {
            this.client = new FTPClient();
            this.client.setDefaultTimeout(5000);
            this.client.connect(this.server, this.port);
            this.client.login(this.user, this.password);
        }
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public void disconnect() throws IOException {
        this.client.disconnect();
    }

    public boolean fileExists(String file) throws IOException {
        return this.client.listFiles(file).length > 0;
    }

    public boolean changeWorkingDirectory(String path) throws Exception {
        return this.client.changeWorkingDirectory(path);
    }

    public void setTimestamp(String path, LocalDateTime time) throws Exception {
        String timestamp = time.format(new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter());
        this.client.setModificationTime(path, timestamp);
    }
}

