/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

public class FileContainsFileText
extends TypeSafeMatcher<File> {
    private final File fileContentToMatch;
    private final List<String> fileToMatchContent = new ArrayList<String>();
    private int lineToMatchIndex = 0;

    public static Matcher<File> hasFileContent(String fileLocation) {
        return new FileContainsFileText(fileLocation);
    }

    private FileContainsFileText(String fileLocation) {
        try {
            this.fileContentToMatch = new File(((Object)((Object)this)).getClass().getClassLoader().getResource(fileLocation).toURI());
            try (BufferedReader contentToMatchReader = Files.newBufferedReader(this.fileContentToMatch.toPath(), Charset.defaultCharset());){
                String line;
                while ((line = contentToMatchReader.readLine()) != null) {
                    this.fileToMatchContent.add(line);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Could not find a match between the provided file and " + this.fileContentToMatch.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matchesSafely(File file) {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                if (this.fileToMatchContent.get(this.lineToMatchIndex).trim().equals(currentLine.trim())) {
                    if (this.lineToMatchIndex == this.fileToMatchContent.size() - 1) {
                        boolean bl = true;
                        return bl;
                    }
                    ++this.lineToMatchIndex;
                    continue;
                }
                this.lineToMatchIndex = 0;
            }
            return false;
        }
        catch (IOException e) {
            Assert.fail((String)String.format("Exception %s caught while reading the file %s", e.getMessage(), file.getAbsolutePath()));
            return false;
        }
    }
}

