/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.process.rules;

import io.qameta.allure.Attachment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mule.runtime.core.internal.processor.strategy.ProactorStreamEmitterProcessingStrategyFactory;
import org.mule.runtime.core.privileged.util.MapUtils;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.test.infrastructure.process.MuleStatusProbe;
import org.mule.test.infrastructure.process.rules.MuleInstallation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleDeployment
extends MuleInstallation {
    private static final long POLL_DELAY_MILLIS = 1000L;
    private static final String DEFAULT_DEPLOYMENT_TIMEOUT = "60000";
    private static final boolean STOP_ON_EXIT = Boolean.parseBoolean(System.getProperty("mule.test.stopOnExit", "true"));
    private static final boolean DEBUGGING_ENABLED = Boolean.parseBoolean(System.getProperty("mule.test.debug", "false"));
    private static final String REMOTE_REPOSITORIES = System.getProperty("mule.test.repositories", "");
    private static final String DEBUG_PORT = System.getProperty("mule.test.debug.port", "5005");
    private static Logger logger = LoggerFactory.getLogger(MuleDeployment.class);
    private static PollingProber prober;
    private String locationSuffix = "";
    private int deploymentTimeout = Integer.parseInt(System.getProperty("mule.test.deployment.timeout", "60000"));
    private final List<String> applications = new ArrayList<String>();
    private final List<String> domains = new ArrayList<String>();
    private final List<String> domainBundles = new ArrayList<String>();
    private final List<String> libraries = new ArrayList<String>();
    private MuleProcessController mule;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Supplier<String>> propertiesUsingLambdas = new HashMap<String, Supplier<String>>();
    private final List<String> parameters = new ArrayList<String>();
    private final Thread shutdownHookThread = new Thread(this::after);

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String zippedDistribution) {
        return new Builder(zippedDistribution);
    }

    protected MuleDeployment() {
    }

    protected MuleDeployment(String zippedDistribution) {
        super(zippedDistribution);
    }

    private String[] toArray(Map<String, String> map) {
        ArrayList values = new ArrayList();
        map.forEach((key, value) -> values.add(key + "=" + value));
        return values.toArray(new String[0]);
    }

    private String[] toArray(List<String> parameters) {
        return parameters.toArray(new String[0]);
    }

    @Override
    public Statement apply(final Statement base, Description description) {
        this.location = description.getTestClass().getSimpleName() + this.locationSuffix;
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    MuleDeployment.this.before();
                    base.evaluate();
                }
                finally {
                    MuleDeployment.this.after();
                }
            }
        };
    }

    @Override
    protected void before() throws Throwable {
        super.before();
        prober = new PollingProber((long)this.deploymentTimeout, 1000L);
        this.mule = this.locationSuffix != null && !this.locationSuffix.isEmpty() ? new MuleProcessController(this.getMuleHome(), this.locationSuffix) : new MuleProcessController(this.getMuleHome());
        this.addShutdownHooks();
        try {
            this.doBefore();
        }
        catch (Error e) {
            this.logServerError(e);
        }
    }

    private void logServerError(Error e) throws IOException {
        logger.error("====================== Server log ===============================");
        Files.lines(this.mule.getLog().toPath()).forEach(arg_0 -> ((Logger)logger).error(arg_0));
        logger.error("=================================================================");
        logger.error("Cause: " + e.getMessage());
    }

    private void doBefore() {
        if (this.mule.isRunning()) {
            logger.warn("Mule Server was already running");
            this.libraries.forEach(library -> this.mule.addLibrary(new File((String)library)));
            logger.info("Redeploying domain bundles");
            this.domainBundles.forEach(domainBundle -> this.mule.deployDomainBundle((String)domainBundle));
            logger.info("Redeploying domains");
            this.domains.forEach(domain -> this.redeployDomain((String)domain));
            logger.info("Redeploying applications");
            this.applications.forEach(application -> this.redeploy((String)application));
            logger.info("Redeployment successful");
        } else {
            this.libraries.forEach(library -> this.mule.addLibrary(new File((String)library)));
            this.domainBundles.forEach(domainBundle -> this.mule.deployDomainBundle((String)domainBundle));
            this.domains.forEach(domain -> this.mule.deployDomain((String)domain));
            this.applications.forEach(application -> this.mule.deploy((String)application));
            logger.info("Starting Mule Server");
            if (DEBUGGING_ENABLED) {
                this.setupDebugging();
            }
            if (StringUtils.isNotEmpty((CharSequence)REMOTE_REPOSITORIES)) {
                this.mule.addConfProperty(String.format("-D%s=%s", "mule.repository.repositories", REMOTE_REPOSITORIES));
            }
            this.resolvePropertiesUsingLambdas();
            this.startMule();
            logger.info("Deployment successful");
        }
    }

    private void resolvePropertiesUsingLambdas() {
        this.propertiesUsingLambdas.forEach((propertyName, propertySupplierLambda) -> this.properties.put((String)propertyName, (String)propertySupplierLambda.get()));
    }

    private void setupDebugging() {
        this.mule.addConfProperty("-Xdebug");
        this.mule.addConfProperty("-Xnoagent");
        this.mule.addConfProperty("-Djava.compiler=NONE");
        this.mule.addConfProperty("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + DEBUG_PORT);
        logger.info("Listening for remote debugger to attach at port: " + DEBUG_PORT);
    }

    private void redeployDomain(String domain) {
        this.mule.undeployDomain(this.getName(domain));
        Awaitility.await((String)("Domain " + domain + " is undeployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> !this.mule.isDomainDeployed(this.getName(domain)));
        this.mule.deployDomain(domain);
        Awaitility.await((String)("Domain " + domain + " is deployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> this.mule.isDomainDeployed(this.getName(domain)));
    }

    private void redeploy(String application) {
        this.mule.undeploy(this.getName(application));
        Awaitility.await((String)("Application " + application + " is undeployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> !this.mule.isDeployed(this.getName(application)));
        this.mule.deploy(application);
        Awaitility.await((String)("Application " + application + " is deployed")).atMost((long)this.deploymentTimeout, TimeUnit.MILLISECONDS).until(() -> this.mule.isDeployed(this.getName(application)));
    }

    private String getName(String application) {
        return FilenameUtils.removeExtension((String)FilenameUtils.getName((String)application));
    }

    private void checkAppIsDeployed(final String appName) {
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                return MuleDeployment.this.mule.isDeployed(appName);
            }

            public String describeFailure() {
                return "Application " + appName + " is not deployed after " + MuleDeployment.this.deploymentTimeout / 1000 + " seconds.";
            }
        });
    }

    private void checkDomainIsDeployed(final String domainName) {
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                return MuleDeployment.this.mule.isDomainDeployed(domainName);
            }

            public String describeFailure() {
                return "Domain " + domainName + " is not deployed after " + MuleDeployment.this.deploymentTimeout / 1000 + " seconds.";
            }
        });
    }

    @Override
    protected void after() {
        if (STOP_ON_EXIT) {
            this.stopMule();
            super.after();
        }
        this.removeShutdownHooks();
    }

    public void startMule() {
        if (!this.mule.isRunning()) {
            this.mule.start((String[])ArrayUtils.addAll((Object[])this.toArray(this.parameters), (Object[])this.toArray(this.properties)));
            this.domains.forEach(domain -> this.checkDomainIsDeployed(this.getName((String)domain)));
            this.applications.forEach(application -> this.checkAppIsDeployed(this.getName((String)application)));
        } else {
            logger.warn("Mule Server was already running");
        }
    }

    public void stopMule() {
        if (this.mule.isRunning()) {
            logger.info("Stopping Mule Server");
            this.mule.stop(new String[0]);
            prober.check(MuleStatusProbe.isNotRunning(this.mule));
        } else {
            logger.warn("Mule Server was not running");
        }
    }

    private void addShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    private void removeShutdownHooks() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
    }

    @Attachment(value="Properties")
    public String attachProperties() {
        return MapUtils.toString(this.properties, (boolean)true).replaceAll("(?<=\\.password=)(.*)", "****");
    }

    @Attachment(value="Server log ", type="text/plain", fileExtension=".log")
    public byte[] attachServerLog() {
        try {
            return Files.readAllBytes(this.mule.getLog().toPath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Attachment(value="Application {appName} log", type="text/plain", fileExtension=".log")
    public byte[] attachAppLog(String appName) {
        try {
            return Files.readAllBytes(this.mule.getLog(appName).toPath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public MuleProcessController getMuleProcessController() {
        return this.mule;
    }

    public static class Builder {
        MuleDeployment deployment;

        Builder() {
            this.deployment = new MuleDeployment();
        }

        Builder(String zippedDistribution) {
            this.deployment = new MuleDeployment(zippedDistribution);
        }

        public MuleDeployment deploy() {
            return this.deployment;
        }

        public Builder timeout(int seconds) {
            this.deployment.deploymentTimeout = seconds * 1000;
            return this;
        }

        public Builder withProperty(String property, String value) {
            this.deployment.properties.put(property, value);
            return this;
        }

        public Builder withProcessingStrategyFactory(String factoryClassName) {
            this.deployment.properties.put("-M-Dorg.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory", factoryClassName);
            return this;
        }

        public Builder withProactorProcessingStrategy() {
            return this.withProcessingStrategyFactory(ProactorStreamEmitterProcessingStrategyFactory.class.getName());
        }

        public Builder withPropertyUsingLambda(String property, Supplier<String> propertySupplier) {
            this.deployment.propertiesUsingLambdas.put(property, propertySupplier);
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.deployment.properties.putAll(properties);
            return this;
        }

        public Builder withParameters(String ... parameters) {
            Collections.addAll(this.deployment.parameters, parameters);
            return this;
        }

        public Builder withApplications(String ... applications) {
            Collections.addAll(this.deployment.applications, applications);
            return this;
        }

        public Builder locationSuffix(String suffix) {
            this.deployment.locationSuffix = suffix;
            return this;
        }

        public Builder withDomains(String ... domains) {
            Collections.addAll(this.deployment.domains, domains);
            return this;
        }

        public Builder withDomainBundles(String ... domainBundles) {
            Collections.addAll(this.deployment.domainBundles, domainBundles);
            return this;
        }

        public Builder withLibraries(String ... libraries) {
            Collections.addAll(this.deployment.libraries, libraries);
            return this;
        }
    }
}

