/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.infrastructure.maven;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutLogger;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class MavenTestUtils {
    private static final String M_2_REPO = "/.m2/repository";
    private static final String USER_HOME = "user.home";
    private static final URL MAVEN_ARTIFACTS_DIRECTORY = MavenTestUtils.class.getClassLoader().getResource("artifacts");
    private static final List<String> INSTALL_GOALS = Collections.singletonList("install");
    private static final List<String> CLEAN_GOALS = Collections.singletonList("clean");
    private static final InvokerLogger LOGGER = new SystemOutLogger();
    private static final File MAVEN_SETTINGS = new File(System.getProperty("settings.file"));

    private MavenTestUtils() {
    }

    public static File installMavenArtifact(String baseDirectory, BundleDescriptor descriptor) {
        MavenTestUtils.runMavenGoal(INSTALL_GOALS, baseDirectory);
        MavenTestUtils.runMavenGoal(CLEAN_GOALS, baseDirectory);
        return MavenTestUtils.findMavenArtifact(descriptor);
    }

    public static File findMavenArtifact(BundleDescriptor descriptor) {
        File artifact = new File(MavenTestUtils.getMavenLocalRepository(), Paths.get(descriptor.getGroupId(), descriptor.getArtifactId(), descriptor.getVersion(), descriptor.getArtifactFileName() + "." + descriptor.getType()).toString());
        if (!artifact.exists()) {
            throw new IllegalArgumentException(String.format("Maven artifact %s does not exists in the local Maven repository", descriptor));
        }
        return artifact;
    }

    private static File getMavenLocalRepository() {
        File mavenLocalRepositoryLocation;
        String buildDirectory = System.getProperty("localRepository");
        if (buildDirectory == null) {
            buildDirectory = System.getProperty(USER_HOME) + M_2_REPO;
        }
        if (!(mavenLocalRepositoryLocation = new File(buildDirectory)).exists()) {
            throw new IllegalArgumentException("Maven repository location couldn't be found, please check your configuration");
        }
        return mavenLocalRepositoryLocation;
    }

    private static void runMavenGoal(List<String> goals, String baseDirectory) {
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setLocalRepositoryDirectory(MavenTestUtils.getMavenLocalRepository());
        invoker.setLogger(LOGGER);
        LOGGER.setThreshold(3);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(goals);
        request.setBatchMode(true);
        String mavenArtifactsAndBaseDirectory = MAVEN_ARTIFACTS_DIRECTORY.toString() + "/" + baseDirectory;
        request.setBaseDirectory(Paths.get(URI.create(mavenArtifactsAndBaseDirectory)).toFile());
        request.setPomFile(Paths.get(URI.create(mavenArtifactsAndBaseDirectory + "/pom.xml")).toFile());
        request.setShowErrors(true);
        request.setUserSettingsFile(MAVEN_SETTINGS);
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                LOGGER.error(result.getExecutionException().getMessage());
            }
        }
        catch (MavenInvocationException e) {
            throw new RuntimeException("Error running Maven project: " + e.getMessage());
        }
    }

    public static BundleDescriptor getApplicationBundleDescriptor(String appName, Optional<String> classifier) {
        return new BundleDescriptor.Builder().setGroupId("test").setArtifactId(appName).setVersion("1.0.0").setClassifier(classifier.orElse("mule-application")).build();
    }

    public static BundleDescriptor getDomainBundleDescriptor(String appName) {
        return new BundleDescriptor.Builder().setGroupId("test").setArtifactId(appName).setVersion("1.0.0").setClassifier("mule-domain").build();
    }
}

