/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import java.util.Map;
import org.mule.api.MuleException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.component.JavaComponent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.model.Model;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.exception.AbstractExceptionListener;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.service.ServiceAsyncReplyCompositeMessageSource;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestEntryPointResolverSet;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestResponseAggregator;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;

public abstract class AbstractScriptConfigBuilderTestCase
extends FunctionalTestCase {
    private boolean legacy;

    protected AbstractScriptConfigBuilderTestCase() {
        this(false);
    }

    protected AbstractScriptConfigBuilderTestCase(boolean legacy) {
        this.legacy = legacy;
    }

    public void testManagerConfig() throws Exception {
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"true", (Object)muleContext.getRegistry().lookupObject("doCompression"));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)muleContext.getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        MessagingExceptionHandler es = muleContext.getRegistry().lookupModel("main").getExceptionListener();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)es);
        AbstractScriptConfigBuilderTestCase.assertTrue((String)es.getClass().getName(), (boolean)(es instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() throws MuleException {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("fruitBowlEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        MessagePropertyFilter filter = (MessagePropertyFilter)endpoint.getFilter();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"foo=bar", (String)filter.getPattern());
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("testEPWithCS");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)ep);
    }

    public void testEndpointConfig() throws MuleException {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("waterMelonEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        InboundEndpoint ep = ((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoint("Orange");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)ep);
        List responseTransformers = ep.getResponseTransformers();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)responseTransformers);
        AbstractScriptConfigBuilderTestCase.assertFalse((boolean)responseTransformers.isEmpty());
        Object responseTransformer = responseTransformers.get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(responseTransformer instanceof TestCompressionTransformer));
    }

    public void testExceptionStrategy() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupModel("main").getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)service.getExceptionListener()).getMessageProcessors().size() > 0 ? 1 : 0) != 0);
        OutboundEndpoint ep = (OutboundEndpoint)((AbstractExceptionListener)service.getExceptionListener()).getMessageProcessors().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://orange.exceptions", (String)ep.getEndpointURI().toString());
    }

    public void testTransformerConfig() {
        Transformer t = muleContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)t.getReturnDataType(), (Object)DataTypeFactory.STRING);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        Model model = muleContext.getRegistry().lookupModel("main");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)model);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"main", (String)model.getName());
        if (this.legacy) {
            AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof LegacyEntryPointResolverSet));
        } else {
            AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof TestEntryPointResolverSet));
        }
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getExceptionListener() instanceof TestExceptionStrategy));
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)model.getExceptionListener()).getMessageProcessors().size() > 0 ? 1 : 0) != 0);
        OutboundEndpoint ep = (OutboundEndpoint)((AbstractExceptionListener)model.getExceptionListener()).getMessageProcessors().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://component.exceptions", (String)ep.getEndpointURI().toString());
    }

    public void testEndpointPropertiesConfig() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("endpointWithProps");
        Map props = endpoint.getProperties();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)props);
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"9", props.get("segments"));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"4.21", props.get("radius"));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"Juicy Baby!", props.get("brand"));
        AbstractScriptConfigBuilderTestCase.assertNotNull(props.get("listProperties"));
        List list = (List)props.get("listProperties");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)3, (int)list.size());
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop1", list.get(0));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop2", list.get(1));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop3", list.get(2));
        AbstractScriptConfigBuilderTestCase.assertNotNull(props.get("arrayProperties"));
        list = (List)props.get("arrayProperties");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)3, (int)list.size());
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop4", list.get(0));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop5", list.get(1));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop6", list.get(2));
        AbstractScriptConfigBuilderTestCase.assertNotNull(props.get("mapProperties"));
        props = (Map)props.get("mapProperties");
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop1", props.get("prop1"));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop2", props.get("prop2"));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)6, (int)endpoint.getProperties().size());
    }

    public void testOutboundRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getOutboundMessageProcessor());
        OutboundRouterCollection router = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)router.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getRoutes().size());
        OutboundRouter route1 = (OutboundRouter)router.getRoutes().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof OutboundPassThroughRouter));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)route1.getRoutes().size());
    }

    public void testBindingConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getComponent());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(service.getComponent() instanceof JavaComponent));
        List bindings = ((JavaComponent)service.getComponent()).getInterfaceBindings();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)bindings);
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)bindings.size());
        InterfaceBinding route1 = (InterfaceBinding)bindings.get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals(FruitCleaner.class, (Object)route1.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"wash", (String)route1.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route1.getEndpoint());
        InterfaceBinding route2 = (InterfaceBinding)bindings.get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals(FruitCleaner.class, (Object)route2.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"polish", (String)route2.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route1.getEndpoint());
    }

    public void testDescriptorEndpoints() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)((OutboundRouterCollection)service.getOutboundMessageProcessor()).getRoutes().size());
        OutboundRouter router = (OutboundRouter)((OutboundRouterCollection)service.getOutboundMessageProcessor()).getRoutes().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getRoutes().size());
        MessageProcessor mp = (MessageProcessor)router.getRoutes().get(0);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)mp);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(mp instanceof ImmutableEndpoint));
        ImmutableEndpoint endpoint = (ImmutableEndpoint)mp;
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"appleInEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformers());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().size());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)((ServiceCompositeMessageSource)service.getMessageSource()).getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(((ServiceCompositeMessageSource)service.getMessageSource()).getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        ForwardingCatchAllStrategy fcas = (ForwardingCatchAllStrategy)((ServiceCompositeMessageSource)service.getMessageSource()).getCatchAllStrategy();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)fcas.getEndpoint());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://catch.all", (String)fcas.getEndpoint().getEndpointURI().toString());
        endpoint = ((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoint("orangeEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeQ", (String)endpoint.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformers());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
    }

    public void testInboundRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getMessageSource());
        ServiceCompositeMessageSource messageRouter = (ServiceCompositeMessageSource)service.getMessageSource();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)0, (int)messageRouter.getMessageProcessors().size());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(messageRouter.getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
    }

    public void testResponseRouterConfig() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)service.getAsyncReplyMessageSource());
        ServiceAsyncReplyCompositeMessageSource messageRouter = service.getAsyncReplyMessageSource();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((long)10001L, (long)messageRouter.getTimeout());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)messageRouter.getMessageProcessors().size());
        MessageProcessor router = (MessageProcessor)messageRouter.getMessageProcessors().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(router instanceof TestResponseAggregator));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getEndpoints());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
        InboundEndpoint ep = (InboundEndpoint)messageRouter.getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response1", (String)ep.getEndpointURI().getAddress());
        ep = (InboundEndpoint)messageRouter.getEndpoints().get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"AppleResponseQueue", (String)ep.getEndpointURI().getAddress());
    }
}

