/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleServer;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestNotification;
import org.mule.util.NumberUtils;
import org.mule.util.StringMessageUtils;

public class FunctionalTestComponent
implements Callable,
Initialisable,
Disposable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final int STREAM_SAMPLE_SIZE = 4;
    public static final int STREAM_BUFFER_SIZE = 4096;
    private EventCallback eventCallback;
    private Object returnMessage = null;
    private boolean appendComponentName = false;
    private boolean throwException = false;
    private boolean enableMessageHistory = true;
    private boolean addReceived = true;
    private boolean asString = true;
    private List messageHistory;

    public LifecycleTransitionResult initialise() {
        if (this.enableMessageHistory) {
            this.messageHistory = new CopyOnWriteArrayList();
        }
        return LifecycleTransitionResult.OK;
    }

    public void dispose() {
    }

    public Object onCall(MuleEventContext context) throws Exception {
        if (this.enableMessageHistory) {
            this.messageHistory.add(context.transformMessage());
        }
        String contents = context.transformMessageToString();
        String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in service: " + context.getService().getName() + ". Content is: " + StringMessageUtils.truncate((String)contents, (int)100, (boolean)true)), (char)'*', (int)80);
        this.logger.info((Object)msg);
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(context, this);
        }
        Object replyMessage = this.returnMessage != null ? this.returnMessage : (this.isAsString() ? (this.addReceived ? FunctionalTestComponent.received(contents) : contents) + (this.appendComponentName ? " " + context.getService().getName() : "") : context.getMessage().getPayload());
        MuleContext muleContext = context.getMuleContext();
        if (muleContext == null) {
            this.logger.warn((Object)"No MuleContext available from MuleEventContext");
            muleContext = MuleServer.getMuleContext();
        }
        muleContext.fireNotification((ServerNotification)new FunctionalTestNotification(context, replyMessage, -999999));
        if (this.throwException) {
            throw new FunctionalTestException();
        }
        return replyMessage;
    }

    public static String received(String contents) {
        return contents + " Received";
    }

    public Object onReceive(Object data) throws Exception {
        MuleEventContext context = RequestContext.getEventContext();
        String contents = data.toString();
        String msg = StringMessageUtils.getBoilerPlate((String)("Message Received in service: " + context.getService().getName() + ". Content is: " + StringMessageUtils.truncate((String)contents, (int)100, (boolean)true)), (char)'*', (int)80);
        this.logger.info((Object)msg);
        if (this.eventCallback != null) {
            this.eventCallback.eventReceived(context, this);
        }
        Object replyMessage = this.returnMessage != null ? this.returnMessage : contents + " Received";
        context.getMuleContext().fireNotification((ServerNotification)new FunctionalTestNotification(context, replyMessage, -999999));
        if (this.throwException) {
            if (this.returnMessage != null && this.returnMessage instanceof Exception) {
                throw (Exception)this.returnMessage;
            }
            throw new DefaultMuleException(MessageFactory.createStaticMessage((String)"Functional Test Service Exception"));
        }
        return replyMessage;
    }

    public EventCallback getEventCallback() {
        return this.eventCallback;
    }

    public void setEventCallback(EventCallback eventCallback) {
        this.eventCallback = eventCallback;
    }

    public Object getReturnMessage() {
        return this.returnMessage;
    }

    public void setReturnMessage(Object returnMessage) {
        this.returnMessage = returnMessage;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public boolean isAppendComponentName() {
        return this.appendComponentName;
    }

    public void setAppendComponentName(boolean appendComponentName) {
        this.appendComponentName = appendComponentName;
    }

    public boolean isEnableMessageHistory() {
        return this.enableMessageHistory;
    }

    public void setEnableMessageHistory(boolean enableMessageHistory) {
        this.enableMessageHistory = enableMessageHistory;
    }

    public int getReceivedMessages() {
        if (this.messageHistory != null) {
            return this.messageHistory.size();
        }
        return NumberUtils.INTEGER_MINUS_ONE;
    }

    public Object getReceivedMessage(int number) {
        Object message = null;
        if (this.messageHistory != null && number <= this.messageHistory.size()) {
            message = this.messageHistory.get(number - 1);
        }
        return message;
    }

    public Object getLastReceivedMessage() {
        if (this.messageHistory != null) {
            return this.messageHistory.get(this.messageHistory.size() - 1);
        }
        return null;
    }

    public boolean isAddReceived() {
        return this.addReceived;
    }

    public void setAddReceived(boolean addReceived) {
        this.addReceived = addReceived;
    }

    public boolean isAsString() {
        return this.asString;
    }

    public void setAsString(boolean asString) {
        this.asString = asString;
    }
}

