/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import javax.resource.spi.work.WorkListener;
import org.mule.RegistryContext;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.impl.model.MuleProxy;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.TestingWorkListener;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.testmodels.mule.TestMuleProxy;
import org.mule.tck.testmodels.mule.TestSedaComponent;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.model.UMOModel;

public abstract class FunctionalTestCase
extends AbstractMuleTestCase {
    public static final String TEST_MESSAGE_RESPONSE = FunctionalTestComponent.received("Test Message");

    protected UMOManagementContext createManagementContext() throws Exception {
        UMOManagementContext context;
        if (this.getTestInfo().isDisposeManagerPerSuite() && managementContext != null) {
            context = managementContext;
        } else {
            ConfigurationBuilder builder = this.getBuilder();
            context = builder.configure(this.getConfigResources());
            RegistryContext.getConfiguration().setDefaultWorkListener((WorkListener)new TestingWorkListener());
        }
        return context;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        MuleXmlConfigurationBuilder builder = new MuleXmlConfigurationBuilder();
        builder.setStartContext(this.isStartContext());
        return builder;
    }

    protected abstract String getConfigResources();

    protected FunctionalTestComponent lookupTestComponent(String modelName, String componentName) throws UMOException {
        UMOModel m = managementContext.getRegistry().lookupModel(modelName);
        FunctionalTestCase.assertNotNull((String)("Model " + m + " not found"), (Object)m);
        UMOComponent c = m.getComponent(componentName);
        FunctionalTestCase.assertNotNull((String)("Component " + c + " not found"), (Object)c);
        FunctionalTestCase.assertTrue((String)"Component should be a TestSedaComponent", (boolean)(c instanceof TestSedaComponent));
        MuleProxy proxy = ((TestSedaComponent)c).getProxy();
        FunctionalTestCase.assertNotNull((String)("Component " + c + " does not have a proxy"), (Object)proxy);
        FunctionalTestCase.assertTrue((String)"Proxy should be a TestMuleProxy", (boolean)(proxy instanceof TestMuleProxy));
        Object component = ((TestMuleProxy)proxy).getComponent();
        FunctionalTestCase.assertNotNull((String)"No component for proxy", (Object)component);
        FunctionalTestCase.assertTrue((String)"Component should be a FunctionalTestComponent", (boolean)(component instanceof FunctionalTestComponent));
        return (FunctionalTestComponent)component;
    }
}

