/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.oauth;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.test.oauth.TestOAuthConnection;

public class TestOAuthOperations {
    private static int executedCounter = 0;

    public TestOAuthConnection getConnection(@Connection TestOAuthConnection connection) {
        return connection;
    }

    public void tokenExpired(@Connection TestOAuthConnection connection) {
        OAuthState state = connection.getState().getState();
        if (state != null && !state.getAccessToken().endsWith("refreshed")) {
            if (state instanceof AuthorizationCodeState) {
                throw new AccessTokenExpiredException(((AuthorizationCodeState)state).getResourceOwnerId());
            }
            throw new AccessTokenExpiredException();
        }
    }

    public PagingProvider<TestOAuthConnection, String> pagedOperation(final @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="0") Integer failAt) {
        return new PagingProvider<TestOAuthConnection, String>(){
            private int count = 1;
            private boolean done = false;

            public List<String> getPage(TestOAuthConnection connection) {
                if (this.done) {
                    return null;
                }
                OAuthState state = connection.getState().getState();
                if (this.count >= failAt) {
                    if (!state.getAccessToken().endsWith("refreshed")) {
                        if (state instanceof AuthorizationCodeState) {
                            throw new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new AccessTokenExpiredException(((AuthorizationCodeState)state).getResourceOwnerId()));
                        }
                        throw new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new AccessTokenExpiredException());
                    }
                    this.done = true;
                }
                return Arrays.asList("item " + this.count++);
            }

            public Optional<Integer> getTotalResults(TestOAuthConnection connection) {
                return Optional.empty();
            }

            public void close(TestOAuthConnection connection) throws MuleException {
            }
        };
    }

    public TestOAuthConnection getFlackyConnection(@Connection TestOAuthConnection connection) {
        if (executedCounter++ % 2 == 0) {
            throw new AccessTokenExpiredException();
        }
        return connection;
    }

    @MediaType(value="*/*")
    public InputStream getStream(String content) {
        return new ByteArrayInputStream(content.getBytes());
    }

    @MediaType(value="*/*")
    public String getStreamContentWithFlackyConnection(@Connection TestOAuthConnection connection, InputStream content) {
        String result = IOUtils.toString((InputStream)content);
        if (executedCounter++ % 2 == 0) {
            throw new AccessTokenExpiredException();
        }
        return result;
    }
}

