/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.extension.reconnection;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.extension.test.extension.reconnection.ReconnectableConnectionProvider;
import org.mule.extension.test.extension.reconnection.metadata.RetryPolicyOutputResolver;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class ReconnectionOperations {
    public static volatile int closePagingProviderCalls = 0;
    public static volatile int getPageCalls = 0;

    public void switchConnection() {
        ReconnectableConnectionProvider.fail = !ReconnectableConnectionProvider.fail;
    }

    @OutputResolver(output=RetryPolicyOutputResolver.class)
    public RetryPolicyTemplate getRetryPolicyTemplate(@Connection ReconnectableConnection connection, RetryPolicyTemplate template) {
        return template;
    }

    public PagingProvider<ReconnectableConnection, ReconnectableConnection> pagedOperation(final Integer failOn, final MuleErrors withErrorType) {
        return new PagingProvider<ReconnectableConnection, ReconnectableConnection>(){

            public List<ReconnectableConnection> getPage(ReconnectableConnection connection) {
                if (++getPageCalls == failOn) {
                    if (withErrorType.equals((Object)MuleErrors.CONNECTIVITY)) {
                        throw new ModuleException((ErrorTypeDefinition)withErrorType, (Throwable)new ConnectionException("Failed to retrieve Page"));
                    }
                    throw new IllegalArgumentException("An illegal argument was received.");
                }
                return Collections.singletonList(connection);
            }

            public Optional<Integer> getTotalResults(ReconnectableConnection connection) {
                return Optional.empty();
            }

            public void close(ReconnectableConnection connection) {
                ++closePagingProviderCalls;
            }
        };
    }

    public PagingProvider<ReconnectableConnection, ReconnectableConnection> stickyPagedOperation(final Integer failOn, final MuleErrors withErrorType) {
        return new PagingProvider<ReconnectableConnection, ReconnectableConnection>(){

            public List<ReconnectableConnection> getPage(ReconnectableConnection connection) {
                if (++getPageCalls == failOn) {
                    if (withErrorType.equals((Object)MuleErrors.CONNECTIVITY)) {
                        throw new ModuleException((ErrorTypeDefinition)withErrorType, (Throwable)new ConnectionException("Failed to retrieve Page"));
                    }
                    throw new IllegalArgumentException("An illegal argument was received.");
                }
                return Collections.singletonList(connection);
            }

            public Optional<Integer> getTotalResults(ReconnectableConnection connection) {
                return Optional.empty();
            }

            public void close(ReconnectableConnection connection) {
                ++closePagingProviderCalls;
            }

            public boolean useStickyConnections() {
                return true;
            }
        };
    }
}

