/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.extension.reconnection;

import jakarta.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;

public class NonReconnectableSource
extends Source<Void, Void> {
    public static volatile boolean fail = false;
    @Connection
    ConnectionProvider<ReconnectableConnection> connectionProvider;
    @Inject
    SchedulerService schedulerService;
    private Scheduler scheduler;
    private ScheduledFuture<?> scheduleWithFixedDelay;
    public static final AtomicInteger attempts = new AtomicInteger(0);

    public void onStart(SourceCallback<Void, Void> sourceCallback) throws MuleException {
        if (fail) {
            attempts.getAndIncrement();
            throw new RuntimeException("Fail starting source");
        }
        attempts.set(0);
        ReconnectableConnection connection = (ReconnectableConnection)this.connectionProvider.connect();
        this.scheduler = this.schedulerService.ioScheduler();
        this.scheduleWithFixedDelay = this.scheduler.scheduleWithFixedDelay(() -> {
            if (fail) {
                sourceCallback.onConnectionException(new ConnectionException((Throwable)new RuntimeException(), (Object)connection));
            } else {
                sourceCallback.handle(Result.builder().build());
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void onStop() {
        if (this.scheduleWithFixedDelay != null) {
            this.scheduleWithFixedDelay.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }
}

