/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.test.petstore.extension.PetStoreClient;

public abstract class PetStoreConnectionProvider<T extends PetStoreClient>
implements ConnectionProvider<T>,
Lifecycle {
    private static final String USERNAME = "john";
    @Inject
    protected MuleContext muleContext;
    @RefName
    protected String configName;
    @Parameter
    protected String username;
    @Parameter
    @Password
    protected String password;
    @Parameter
    @Optional
    protected TlsContextFactory tls;
    @Optional
    @Parameter
    protected Date openingDate;
    @Optional
    @Parameter
    protected List<Date> closedForHolidays;
    @Optional
    @Parameter
    protected List<LocalDateTime> discountDates;
    private int initialise;
    private int start;
    private int stop;
    private int dispose = 0;

    public T connect() throws ConnectionException {
        if (!this.username.equals(USERNAME)) {
            throw new ConnectionException("We only know john");
        }
        return (T)new PetStoreClient(this.username, this.password, this.tls, this.configName, this.openingDate, this.closedForHolidays, this.discountDates);
    }

    public void disconnect(PetStoreClient connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public ConnectionValidationResult validate(PetStoreClient connection) {
        if (connection.getUsername().equals(USERNAME) && connection.getPassword().equals("doe")) {
            return ConnectionValidationResult.success();
        }
        return ConnectionValidationResult.failure((String)"Invalid credentials", (Exception)new Exception("Invalid credentials"));
    }

    public void dispose() {
        ++this.dispose;
    }

    public void initialise() throws InitialisationException {
        ++this.initialise;
    }

    public void start() throws MuleException {
        ++this.start;
    }

    public void stop() throws MuleException {
        ++this.stop;
    }

    public int getInitialise() {
        return this.initialise;
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public int getDispose() {
        return this.dispose;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Date getOpeningDate() {
        return this.openingDate;
    }
}

