/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.metadata.extension.resolver;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.test.metadata.extension.LocationKey;

public class TestMultiLevelKeyResolver
implements TypeKeysResolver,
InputTypeResolver<LocationKey> {
    public static final String ERROR_MESSAGE = "LocationKey type metadata key was not injected properly in the NamedTypeResolver";
    public static final String AMERICA = "AMERICA";
    public static final String EUROPE = "EUROPE";
    public static final String FRANCE = "FRANCE";
    public static final String ARGENTINA = "ARGENTINA";
    public static final String USA = "USA";
    public static final String USA_DISPLAY_NAME = "United States";
    public static final String BUENOS_AIRES = "BA";
    public static final String LA_PLATA = "LPLT";
    public static final String PARIS = "PRS";
    public static final String SAN_FRANCISCO = "SFO";
    public static final String TEST_MULTI_LEVEL_KEY_RESOLVER = "TestMultiLevelKeyResolver";

    public String getCategoryName() {
        return "MetadataExtensionResolver";
    }

    public String getResolverName() {
        return TEST_MULTI_LEVEL_KEY_RESOLVER;
    }

    public MetadataType getInputMetadata(MetadataContext context, LocationKey key) throws MetadataResolvingException, ConnectionException {
        this.checkLocationKey(key);
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)new MetadataFormat(key.toString(), key.toString(), new String[]{"application/java"})).objectType();
        objectBuilder.addField().key("CONTINENT").value().stringType();
        objectBuilder.addField().key("COUNTRY").value().stringType();
        objectBuilder.addField().key("CITY").value().stringType();
        return objectBuilder.build();
    }

    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        LinkedHashSet keys = Sets.newLinkedHashSet();
        keys.add(TestMultiLevelKeyResolver.buildAmericaKey());
        keys.add(TestMultiLevelKeyResolver.buildEuropeKey());
        return keys;
    }

    public static MetadataKey buildEuropeKey() {
        return MetadataKeyBuilder.newKey((String)EUROPE).withDisplayName(EUROPE).withChild(MetadataKeyBuilder.newKey((String)FRANCE).withChild(MetadataKeyBuilder.newKey((String)PARIS))).build();
    }

    public static MetadataKey buildAmericaKey() {
        return MetadataKeyBuilder.newKey((String)AMERICA).withDisplayName(AMERICA).withChild(MetadataKeyBuilder.newKey((String)ARGENTINA).withChild(MetadataKeyBuilder.newKey((String)BUENOS_AIRES)).withChild(MetadataKeyBuilder.newKey((String)LA_PLATA))).withChild(MetadataKeyBuilder.newKey((String)USA).withDisplayName(USA_DISPLAY_NAME).withChild(MetadataKeyBuilder.newKey((String)SAN_FRANCISCO))).build();
    }

    private void checkLocationKey(LocationKey key) throws MetadataResolvingException {
        boolean injectedProperly;
        boolean bl = injectedProperly = key != null && key.getContinent().equals(AMERICA) && key.getCountry().equals(USA) && key.getCity().equals(SAN_FRANCISCO);
        if (!injectedProperly) {
            throw new MetadataResolvingException(ERROR_MESSAGE, FailureCode.INVALID_METADATA_KEY);
        }
    }
}

