/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.metadata.extension.resolver;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.test.metadata.extension.LocationKey;
import org.mule.test.metadata.extension.resolver.TestMultiLevelKeyResolver;

public class TestPartialMultiLevelKeyResolver
extends TestMultiLevelKeyResolver
implements PartialTypeKeysResolver<LocationKey>,
OutputTypeResolver<LocationKey> {
    public MetadataKey resolveChilds(MetadataContext context, LocationKey partial) throws MetadataResolvingException, ConnectionException {
        if ("AMERICA".equalsIgnoreCase(partial.getContinent())) {
            if ("ARGENTINA".equalsIgnoreCase(partial.getCountry())) {
                return MetadataKeyBuilder.newKey((String)"AMERICA").withDisplayName("AMERICA").withChild(MetadataKeyBuilder.newKey((String)"ARGENTINA").withChild(MetadataKeyBuilder.newKey((String)"BA")).withChild(MetadataKeyBuilder.newKey((String)"LPLT"))).build();
            }
            return TestPartialMultiLevelKeyResolver.buildAmericaKey();
        }
        if ("EUROPE".equalsIgnoreCase(partial.getContinent())) {
            return TestPartialMultiLevelKeyResolver.buildEuropeKey();
        }
        throw new MetadataResolvingException("Invalid Continent", FailureCode.INVALID_METADATA_KEY);
    }

    public static MetadataKey buildEuropeKey() {
        return MetadataKeyBuilder.newKey((String)"EUROPE").withDisplayName("EUROPE").withChild(MetadataKeyBuilder.newKey((String)"FRANCE").withChild(MetadataKeyBuilder.newKey((String)"PRS"))).build();
    }

    public static MetadataKey buildAmericaKey() {
        return MetadataKeyBuilder.newKey((String)"AMERICA").withDisplayName("AMERICA").withChild(MetadataKeyBuilder.newKey((String)"ARGENTINA").withChild(MetadataKeyBuilder.newKey((String)"BA")).withChild(MetadataKeyBuilder.newKey((String)"LPLT"))).withChild(MetadataKeyBuilder.newKey((String)"USA").withDisplayName("United States").withChild(MetadataKeyBuilder.newKey((String)"SFO"))).build();
    }

    @Override
    public String getResolverName() {
        return "PartialTestMultiLevelKeyResolver";
    }

    public MetadataType getOutputType(MetadataContext context, LocationKey key) throws MetadataResolvingException, ConnectionException {
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)new MetadataFormat(key.toString(), key.toString(), new String[]{"application/java"})).objectType();
        objectBuilder.addField().key(key.getContinent()).value().stringType();
        objectBuilder.addField().key(key.getCity()).value().stringType();
        objectBuilder.addField().key(key.getCountry()).value().stringType();
        return objectBuilder.build();
    }
}

