/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.metadata.extension.resolver;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.test.metadata.extension.LocationKey;
import org.mule.test.metadata.extension.resolver.TestMultiLevelKeyResolver;

public class TestPartialMultiLevelKeyResolver
extends TestMultiLevelKeyResolver
implements PartialTypeKeysResolver<LocationKey> {
    public MetadataKey resolveChilds(MetadataContext context, LocationKey partial) throws MetadataResolvingException, ConnectionException {
        if ("AMERICA".equalsIgnoreCase(partial.getContinent())) {
            if ("ARGENTINA".equalsIgnoreCase(partial.getCountry())) {
                return MetadataKeyBuilder.newKey((String)"AMERICA").withDisplayName("AMERICA").withChild(MetadataKeyBuilder.newKey((String)"ARGENTINA").withChild(MetadataKeyBuilder.newKey((String)"BA")).withChild(MetadataKeyBuilder.newKey((String)"LPLT"))).build();
            }
            return TestPartialMultiLevelKeyResolver.buildAmericaKey();
        }
        if ("EUROPE".equalsIgnoreCase(partial.getContinent())) {
            return TestPartialMultiLevelKeyResolver.buildEuropeKey();
        }
        throw new MetadataResolvingException("Invalid Continent", FailureCode.INVALID_METADATA_KEY);
    }

    public static MetadataKey buildEuropeKey() {
        return MetadataKeyBuilder.newKey((String)"EUROPE").withDisplayName("EUROPE").withChild(MetadataKeyBuilder.newKey((String)"FRANCE").withChild(MetadataKeyBuilder.newKey((String)"PRS"))).build();
    }

    public static MetadataKey buildAmericaKey() {
        return MetadataKeyBuilder.newKey((String)"AMERICA").withDisplayName("AMERICA").withChild(MetadataKeyBuilder.newKey((String)"ARGENTINA").withChild(MetadataKeyBuilder.newKey((String)"BA")).withChild(MetadataKeyBuilder.newKey((String)"LPLT"))).withChild(MetadataKeyBuilder.newKey((String)"USA").withDisplayName("United States").withChild(MetadataKeyBuilder.newKey((String)"SFO"))).build();
    }

    @Override
    public String getResolverName() {
        return "PartialTestMultiLevelKeyResolver";
    }
}

