/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.metadata.extension.resolver;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.test.metadata.extension.resolver.TestMetadataResolverUtils;

public class TestResolverWithCache
implements InputTypeResolver<String>,
OutputTypeResolver<String>,
TypeKeysResolver {
    public static final String MISSING_ELEMENT_ERROR_MESSAGE = "Missing element in the cache. There was no element in the cache for the key: Brand";
    public static final int AGE_VALUE = 16;
    public static final String NAME_VALUE = "Juan";
    public static final String BRAND_VALUE = "Nikdidas";

    public String getCategoryName() {
        return "MetadataExtensionResolver";
    }

    public String getResolverName() {
        return "TestResolverWithCache";
    }

    public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        MetadataCache cache = context.getCache();
        Optional element = cache.get((Serializable)((Object)"Brand"));
        if (!element.isPresent()) {
            throw new MetadataResolvingException(MISSING_ELEMENT_ERROR_MESSAGE, FailureCode.RESOURCE_UNAVAILABLE);
        }
        return this.buildMetadataType((String)element.get());
    }

    public MetadataType getOutputType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        return this.buildMetadataType((String)((Object)context.getCache().computeIfAbsent((Serializable)((Object)"Brand"), k -> BRAND_VALUE)));
    }

    private MetadataType buildMetadataType(String model) {
        return BaseTypeBuilder.create((MetadataFormat)new MetadataFormat(model, model, new String[]{"application/java"})).objectType().build();
    }

    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        context.getCache().put((Serializable)((Object)"Age"), (Serializable)Integer.valueOf(16));
        context.getCache().put((Serializable)((Object)"Name"), (Serializable)((Object)NAME_VALUE));
        return TestMetadataResolverUtils.getKeys(context);
    }
}

