/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.marvel.drstrange;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.annotation.param.stereotype.ComponentId;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.test.marvel.drstrange.DrStrange;
import org.mule.test.marvel.drstrange.ReferableOperationStereotypeDefinition;

@Alias(value="bytes-caster")
@MediaType(value="text/plain")
public class DrStrangeBytesSource
extends Source<InputStream, Void> {
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    private ScheduledFuture sourceCallbackHandleTask;
    @Inject
    private ConfigurationComponentLocator locator;
    @Parameter
    private long castFrequencyInMillis;
    @Parameter
    private String spell;
    @Parameter
    @Optional(defaultValue="1")
    private int spellSize;
    @Parameter
    @Optional
    @AllowedStereotypes(value={ReferableOperationStereotypeDefinition.class})
    private String nextOperationReference;
    @Parameter
    @ComponentId
    private String listenerId;
    @Config
    private DrStrange config;
    private ComponentLocation location;
    private QName ANNOTATION_PARAMETERS = new QName("config", "componentParameters");

    public void onStart(SourceCallback<InputStream, Void> sourceCallback) throws MuleException {
        Component proc;
        Map parameters;
        if (this.nextOperationReference != null && !(parameters = (Map)(proc = (Component)this.locator.find(Location.builderFromStringRepresentation((String)((LocationPart)this.location.getParts().get(0)).getPartPath()).addProcessorsPart().addIndexPart(0).build()).orElseThrow(() -> new IllegalArgumentException("Missing processor after this source"))).getAnnotation(this.ANNOTATION_PARAMETERS)).get("name").equals(this.nextOperationReference)) {
            throw new IllegalArgumentException(String.format("Next processor %s does not match the expected operation %s", parameters.get("name"), this.nextOperationReference));
        }
        this.scheduler = this.schedulerService.cpuLightScheduler();
        this.sourceCallbackHandleTask = this.scheduler.scheduleAtFixedRate(() -> sourceCallback.handle(Result.builder().output((Object)new ByteArrayInputStream(this.getSpellBytes(this.spell))).build()), 0L, this.castFrequencyInMillis, TimeUnit.MILLISECONDS);
    }

    private byte[] getSpellBytes(String spell) {
        while (spell.length() < this.spellSize) {
            spell = spell + spell;
        }
        return spell.getBytes();
    }

    public void onStop() {
        if (this.sourceCallbackHandleTask != null) {
            this.sourceCallbackHandleTask.cancel(false);
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }
}

