/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.sdk.api.annotation.deprecated.Deprecated;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.process.VoidCompletionCallback;
import org.mule.test.heisenberg.extension.model.Attribute;
import org.mule.test.heisenberg.extension.route.AfterCall;
import org.mule.test.heisenberg.extension.route.BeforeCall;
import org.mule.test.heisenberg.extension.route.DrugKillingRoute;
import org.mule.test.heisenberg.extension.route.KillingRoute;
import org.mule.test.heisenberg.extension.route.OtherwiseRoute;
import org.mule.test.heisenberg.extension.route.WhenRoute;

public class HeisenbergRouters
implements Initialisable,
Startable,
Stoppable,
Disposable {
    public static final String NOT_INITIALISED = "not_initialised";
    private String state = "not_initialised";
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="0")
    private int fieldParam;

    public void voidRouter(WhenRoute when, org.mule.runtime.extension.api.runtime.process.VoidCompletionCallback callback) {
        when.getChain().process((Object)this.state, null, r -> callback.success(), (e, r) -> callback.error(e));
    }

    public void sdkVoidRouter(WhenRoute when, VoidCompletionCallback callback) {
        when.getChain().process((Object)this.state, null, r -> callback.success(), (e, r) -> callback.error(e));
    }

    public void concurrentRouteExecutor(WhenRoute when, org.mule.sdk.api.runtime.process.RouterCompletionCallback callback) {
        Consumer<Chain> processor = chain -> {
            Latch latch = new Latch();
            chain.process(result -> latch.release(), (error, result) -> latch.release());
            try {
                latch.await(10000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        Thread first = new Thread(() -> processor.accept(when.getChain()));
        Thread second = new Thread(() -> processor.accept(when.getChain()));
        first.start();
        second.start();
        try {
            first.join();
            second.join();
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
        callback.success(Result.builder().output((Object)"SUCCESS").build());
    }

    @Deprecated(message="Simple routers are too simple, we will no longer suport them.", since="1.2.2")
    public void simpleRouter(WhenRoute when, RouterCompletionCallback callback) {
        when.getChain().process(arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (e, r) -> callback.error(e));
    }

    public void twoRoutesRouter(String processorName, WhenRoute when, @Optional OtherwiseRoute other, RouterCompletionCallback callback) {
        if (when.shouldExecute()) {
            when.getChain().process(org.mule.runtime.extension.api.runtime.operation.Result.builder().output((Object)processorName).attributes((Object)when.getMessage()).build(), arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (e, r) -> callback.error(e));
        } else if (other != null && other.shouldExecute()) {
            other.getChain().process((Object)processorName, null, arg_0 -> ((RouterCompletionCallback)callback).success(arg_0), (e, r) -> callback.error(e));
        } else {
            callback.error((Throwable)new IllegalArgumentException("No route executed"));
        }
    }

    public void stereotypedRoutes(KillingRoute killingRoute, @org.mule.runtime.extension.api.annotation.param.Optional DrugKillingRoute drugKillingRoute, org.mule.sdk.api.runtime.process.RouterCompletionCallback callback) {
        killingRoute.getChain().process(result -> {
            if (drugKillingRoute != null) {
                drugKillingRoute.getChain().process(result, r -> callback.success(Result.builder().output(r.getOutput()).attributes((Object)r.getAttributes()).build()), (e, r) -> callback.error(e));
            } else {
                callback.success(Result.builder().output(result.getOutput()).attributes((Object)result.getAttributes()).build());
            }
        }, (e, r) -> callback.error(e));
    }

    @Summary(value="Allows to take actions over the event before and after the execution of a processor")
    public void spy(String processor, @org.mule.runtime.extension.api.annotation.param.Optional @NullSafe @Expression(value=ExpressionSupport.NOT_SUPPORTED) List<Attribute> withAttributes, @org.mule.runtime.extension.api.annotation.param.Optional BeforeCall beforeCallAssertions, @org.mule.runtime.extension.api.annotation.param.Optional AfterCall afterCallAssertions, org.mule.sdk.api.runtime.process.RouterCompletionCallback callback) {
        Map<String, Object> attr = withAttributes.stream().collect(Collectors.toMap(Attribute::getName, r -> r));
        if (beforeCallAssertions != null) {
            beforeCallAssertions.getChain().process(attr, null, success -> {
                System.out.println(processor);
                if (afterCallAssertions != null) {
                    afterCallAssertions.getChain().process(success, arg_0 -> ((org.mule.sdk.api.runtime.process.RouterCompletionCallback)callback).success(arg_0), (t, e) -> callback.error(t));
                } else {
                    callback.success(success);
                }
            }, (error, lastResult) -> callback.error(error));
        } else if (afterCallAssertions != null) {
            afterCallAssertions.getChain().process(attr, null, arg_0 -> ((org.mule.sdk.api.runtime.process.RouterCompletionCallback)callback).success(arg_0), (t, e) -> callback.error(t));
        } else {
            callback.success(Result.builder().build());
        }
    }

    public void initialise() throws InitialisationException {
        this.checkState(NOT_INITIALISED);
        this.state = "initialise";
    }

    public void start() throws MuleException {
        this.checkState("initialise");
        this.state = "start";
    }

    public void stop() throws MuleException {
        this.checkState("start");
        this.state = "stop";
    }

    public void dispose() {
        try {
            this.checkState("stop");
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
        this.state = "dispose";
    }

    private void checkState(String expected) throws InitialisationException {
        if (!this.state.equals(expected)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Invalid state: expected %s but as %s", (Object[])new Object[]{expected, this.state}), (Initialisable)this);
        }
    }

    public int routerField(int expected, int newValue) {
        Preconditions.checkArgument((expected == this.fieldParam ? 1 : 0) != 0, (String)("Expected " + expected + " but was " + this.fieldParam));
        this.fieldParam = newValue;
        return this.fieldParam;
    }
}

