/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.extension.api.annotation.param.MediaType;

public class HeisenbergOperationLifecycleValidator
implements Initialisable,
Startable,
Stoppable,
Disposable {
    public static final String NOT_INITIALISED = "not_initialised";
    public static int INITIALIZE_CALL_COUNT = 0;
    public static int START_CALL_COUNT = 0;
    public static int STOP_CALL_COUNT = 0;
    public static int DISPOSE_CALL_COUNT = 0;
    private String state = "not_initialised";

    @MediaType(value="*/*")
    public void lifecycleValidator(String expected) {
        if (!expected.equals(this.state)) {
            throw new IllegalStateException(String.format("Expected [%s] but was [%s]", expected, this.state));
        }
    }

    public void initialise() throws InitialisationException {
        this.checkState(NOT_INITIALISED);
        this.state = "initialise";
        ++INITIALIZE_CALL_COUNT;
    }

    public void start() throws MuleException {
        this.checkState("initialise");
        this.state = "start";
        ++START_CALL_COUNT;
    }

    public void stop() throws MuleException {
        this.checkState("start");
        this.state = "stop";
        ++STOP_CALL_COUNT;
    }

    public void dispose() {
        try {
            this.checkState("stop");
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
        this.state = "dispose";
        ++DISPOSE_CALL_COUNT;
    }

    private void checkState(String expected) throws InitialisationException {
        if (!this.state.equals(expected)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Invalid state: expected %s but as %s", (Object[])new Object[]{expected, this.state}), (Initialisable)this);
        }
    }
}

