/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.heisenberg.extension;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.notification.Fires;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.annotation.source.OnBackPressure;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.source.BackPressureContext;
import org.mule.sdk.api.annotation.deprecated.Deprecated;
import org.mule.sdk.api.annotation.source.BackPressure;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.BackPressureMode;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.runtime.source.SourceResult;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergNotificationAction;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.heisenberg.extension.RicinGroup;
import org.mule.test.heisenberg.extension.SourceNotificationProvider;
import org.mule.test.heisenberg.extension.model.Methylamine;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.Weapon;

@EmitsResponse
@Fires(value={SourceNotificationProvider.class})
@Streaming
@MediaType(value="text/plain")
@BackPressure(defaultMode=BackPressureMode.FAIL, supportedModes={BackPressureMode.FAIL, BackPressureMode.DROP})
@Deprecated(message="This source is being tapped by the DEA, it's usage is discouraged.", since="1.6.0", toRemoveIn="3.0.0")
public class SdkHeisenbergSource
extends Source<String, Object> {
    private static final String BATCH_NUMBER = "batchNumber";
    @Inject
    private SchedulerService schedulerService;
    private Scheduler executor;
    private ScheduledFuture<?> scheduledFuture;
    @Config
    private HeisenbergExtension heisenberg;
    @Connection
    private ConnectionProvider<HeisenbergConnection> connectionProvider;
    @Parameter
    private volatile int initialBatchNumber;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="1")
    private int corePoolSize;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="500")
    private long frequency;
    @RefName
    private String refName;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    private Map<String, Object> debtProperties;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    private Map<String, Weapon> usableWeapons;
    private ComponentLocation componentLocation;
    private HeisenbergConnection connection;

    public SdkHeisenbergSource() {
        SdkHeisenbergSource.resetHeisenbergSource();
    }

    public synchronized void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
        Preconditions.checkArgument((this.heisenberg != null ? 1 : 0) != 0, (String)"config not injected");
        ++HeisenbergExtension.sourceTimesStarted;
        HeisenbergSource.configName = this.refName;
        HeisenbergSource.location = this.componentLocation.getLocation();
        if (this.corePoolSize < 0) {
            throw new RuntimeException("corePoolSize cannot be a negative value");
        }
        HeisenbergSource.receivedDebtProperties = this.debtProperties;
        HeisenbergSource.receivedUsableWeapons = this.usableWeapons;
        this.executor = this.schedulerService.cpuLightScheduler();
        this.connection = (HeisenbergConnection)this.connectionProvider.connect();
        this.scheduledFuture = this.executor.scheduleAtFixedRate(() -> {
            Result<String, Object> result = this.makeResult(sourceCallback);
            if (result != null) {
                SourceCallbackContext context = sourceCallback.createContext();
                context.addVariable(BATCH_NUMBER, (Object)this.initialBatchNumber);
                context.fireOnHandle((org.mule.sdk.api.notification.NotificationActionDefinition)HeisenbergNotificationAction.NEW_BATCH, TypedValue.of((Object)this.initialBatchNumber));
                context.fireOnHandle((org.mule.sdk.api.notification.NotificationActionDefinition)HeisenbergNotificationAction.NEXT_BATCH, TypedValue.of((Object)this.frequency));
                sourceCallback.handle(result, context);
            }
        }, 0L, this.frequency, TimeUnit.MILLISECONDS);
    }

    @OnSuccess
    public synchronized void onSuccess(@org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") Long payment, @org.mule.runtime.extension.api.annotation.param.Optional String sameNameParameter, @ParameterGroup(name="Dangerous-Ricin") @DisplayName(value="Dangerous Ricin") RicinGroup ricin, @ParameterGroup(name="Success Info", showInDsl=true) PersonalInfo successInfo, @org.mule.runtime.extension.api.annotation.param.Optional boolean fail, NotificationEmitter notificationEmitter) {
        HeisenbergSource.gatheredMoney += payment.longValue();
        HeisenbergSource.receivedGroupOnSource = ricin != null && ricin.getNextDoor().getAddress() != null;
        HeisenbergSource.receivedInlineOnSuccess = successInfo != null && successInfo.getAge() != null && successInfo.getKnownAddresses() != null && successInfo.getDescription() != null;
        HeisenbergSource.executedOnSuccess = true;
        notificationEmitter.fireLazy((NotificationActionDefinition)HeisenbergNotificationAction.BATCH_DELIVERED, () -> payment, DataType.fromType(Long.class));
        if (fail) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnError
    public synchronized void onError(Error error, @org.mule.runtime.extension.api.annotation.param.Optional String sameNameParameter, @org.mule.runtime.extension.api.annotation.param.Optional Methylamine methylamine, @org.mule.sdk.api.annotation.param.ParameterGroup(name="Dangerous-Ricin") RicinGroup ricin, @org.mule.sdk.api.annotation.param.ParameterGroup(name="Error Info", showInDsl=true) PersonalInfo infoError, @org.mule.runtime.extension.api.annotation.param.Optional boolean propagateError, org.mule.sdk.api.notification.NotificationEmitter notificationEmitter) {
        HeisenbergSource.gatheredMoney = -1L;
        HeisenbergSource.receivedGroupOnSource = ricin != null && ricin.getNextDoor() != null && ricin.getNextDoor().getAddress() != null;
        HeisenbergSource.receivedInlineOnError = infoError != null && infoError.getName() != null && !infoError.getName().equals("Heisenberg") && infoError.getDescription() != null;
        HeisenbergSource.executedOnError = true;
        notificationEmitter.fireLazy((org.mule.sdk.api.notification.NotificationActionDefinition)HeisenbergNotificationAction.BATCH_DELIVERY_FAILED, () -> infoError, DataType.fromType(PersonalInfo.class));
        if (propagateError) {
            throw new RuntimeException("Some internal exception");
        }
    }

    @OnTerminate
    public synchronized void onTerminate(SourceResult sourceResult, NotificationEmitter notificationEmitter) {
        if (sourceResult.isSuccess()) {
            HeisenbergSource.terminateStatus = HeisenbergSource.TerminateStatus.SUCCESS;
            HeisenbergSource.error = Optional.empty();
        } else {
            sourceResult.getInvocationError().ifPresent(parameterError -> {
                HeisenbergSource.terminateStatus = HeisenbergSource.TerminateStatus.ERROR_INVOKE;
                HeisenbergSource.error = Optional.of(parameterError);
            });
            sourceResult.getResponseError().ifPresent(bodyError -> {
                HeisenbergSource.terminateStatus = HeisenbergSource.TerminateStatus.ERROR_BODY;
                HeisenbergSource.error = Optional.of(bodyError);
            });
        }
        HeisenbergSource.executedOnTerminate = true;
        notificationEmitter.fireLazy((NotificationActionDefinition)HeisenbergNotificationAction.BATCH_TERMINATED, () -> sourceResult.getSourceCallbackContext().getVariable(BATCH_NUMBER).get(), DataType.fromType(Integer.class));
    }

    @OnBackPressure
    public void onBackPressure(BackPressureContext ctx, org.mule.sdk.api.notification.NotificationEmitter notificationEmitter) {
        notificationEmitter.fireLazy((org.mule.sdk.api.notification.NotificationActionDefinition)HeisenbergNotificationAction.BATCH_FAILED, () -> ctx.getSourceCallbackContext().getVariable(BATCH_NUMBER).get(), DataType.fromType(Integer.class));
        this.heisenberg.onBackPressure(ctx);
    }

    public synchronized void onStop() {
        if (this.executor != null && this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.executor.stop();
        }
        if (this.connection != null && this.connectionProvider != null) {
            this.connectionProvider.disconnect((Object)this.connection);
        }
        HeisenbergSource.receivedGroupOnSource = false;
        HeisenbergSource.gatheredMoney = 0L;
    }

    private Result<String, Object> makeResult(SourceCallback sourceCallback) {
        if (this.initialBatchNumber < 0) {
            sourceCallback.onConnectionException(new ConnectionException("initialBatchNumber cannot be a negative value"));
            return null;
        }
        return Result.builder().output((Object)String.format("Meth Batch %d. If found by DEA contact %s", ++this.initialBatchNumber, this.connection.getSaulPhoneNumber())).build();
    }

    public static synchronized void resetHeisenbergSource() {
        HeisenbergSource.receivedGroupOnSource = false;
        HeisenbergSource.receivedInlineOnSuccess = false;
        HeisenbergSource.receivedInlineOnError = false;
        HeisenbergSource.receivedDebtProperties = null;
        HeisenbergSource.receivedUsableWeapons = null;
        HeisenbergSource.terminateStatus = HeisenbergSource.TerminateStatus.NONE;
        HeisenbergSource.error = null;
        HeisenbergSource.executedOnSuccess = false;
        HeisenbergSource.executedOnError = false;
        HeisenbergSource.executedOnTerminate = false;
        HeisenbergSource.gatheredMoney = 0L;
        HeisenbergSource.location = null;
        HeisenbergSource.configName = null;
    }
}

