/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.vti.UpdatableVTITemplate;

public class TriggerOldTransitionRows
extends UpdatableVTITemplate {
    private ResultSet resultSet;

    public TriggerOldTransitionRows() throws SQLException {
        this.initializeResultSet();
    }

    private ResultSet initializeResultSet() throws SQLException {
        TriggerExecutionContext triggerExecutionContext;
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if ((triggerExecutionContext = Factory.getTriggerExecutionContext()) == null) {
            throw new SQLException("There are no active triggers", "38000");
        }
        this.resultSet = triggerExecutionContext.getOldRowSet();
        if (this.resultSet == null) {
            throw new SQLException("There is no old transition rows result set for this trigger", "38000");
        }
        return this.resultSet;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.initializeResultSet();
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public void close() throws SQLException {
        this.resultSet.close();
    }
}

