/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.service.oauth.internal.AbstractOAuthDancer;
import org.mule.service.oauth.internal.state.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientCredentialsOAuthDancer
extends AbstractOAuthDancer
implements Startable,
ClientCredentialsOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientCredentialsOAuthDancer.class);
    private final boolean encodeClientCredentialsInBody;

    public DefaultClientCredentialsOAuthDancer(String clientId, String clientSecret, String tokenUrl, String scopes, boolean encodeClientCredentialsInBody, Charset encoding, String responseAccessTokenExpr, String responseRefreshTokenExpr, String responseExpiresInExpr, Map<String, String> customParametersExprs, Function<String, String> resourceOwnerIdTransformer, LockFactory lockProvider, Map<String, DefaultResourceOwnerOAuthContext> tokensStore, HttpClient httpClient, MuleExpressionLanguage expressionEvaluator) {
        super(clientId, clientSecret, tokenUrl, encoding, scopes, responseAccessTokenExpr, responseRefreshTokenExpr, responseExpiresInExpr, customParametersExprs, resourceOwnerIdTransformer, lockProvider, tokensStore, httpClient, expressionEvaluator);
        this.encodeClientCredentialsInBody = encodeClientCredentialsInBody;
    }

    @Override
    public void start() throws MuleException {
        super.start();
        try {
            this.refreshToken().get();
        }
        catch (ExecutionException e) {
            super.stop();
            throw new LifecycleException(e.getCause(), (Object)this);
        }
        catch (InterruptedException e) {
            super.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public CompletableFuture<String> accessToken() throws RequestAuthenticationException {
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(I18nMessageFactory.createStaticMessage((String)String.format("No access token found. Verify that you have authenticated before trying to execute an operation to the API.", new Object[0])));
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    public CompletableFuture<Void> refreshToken() {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        String authorization = null;
        if (this.encodeClientCredentialsInBody) {
            formData.put("client_id", this.clientId);
            formData.put("client_secret", this.clientSecret);
        } else {
            authorization = "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", this.clientId, this.clientSecret).getBytes());
        }
        try {
            TokenResponse tokenResponse = this.invokeTokenUrl(this.tokenUrl, formData, authorization, false, this.encoding);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
            }
            DefaultResourceOwnerOAuthContext defaultUserState = (DefaultResourceOwnerOAuthContext)this.getContext();
            defaultUserState.setAccessToken(tokenResponse.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
            for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
            }
            this.updateResourceOwnerOAuthContext(defaultUserState);
            return CompletableFuture.completedFuture(null);
        }
        catch (TokenNotFoundException | TokenUrlResponseException e) {
            CompletableFuture<Void> exceptionFuture = new CompletableFuture<Void>();
            exceptionFuture.completeExceptionally(e);
            return exceptionFuture;
        }
    }

    public void invalidateContext() {
        this.invalidateContext("default");
    }

    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }
}

