/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.TestUtils;
import org.mule.service.http.test.netty.utils.client.TestSSLNettyClient;
import org.mule.tck.junit4.rule.DynamicPort;

public class ServerHeaderCaseSensitivityTestCase
extends AbstractHttpTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    private static final String A_RAW_REQUEST_WITH_HEADERS = "GET /saveRequest HTTP/1.1\nHost: localhost\nUser-Agent: ObviouslyMe\nHeaderWithCase: HeaderValue\n\n";
    private HttpServer server;
    private HttpListenerRegistry httpListenerRegistry;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestSSLNettyClient testClient = new TestSSLNettyClient("localhost", this.serverPort.getNumber(), executorRule.getExecutor());
    private final BlockingQueue<HttpRequest> receivedRequests = new LinkedBlockingQueue<HttpRequest>();

    @Before
    public void setup() throws IOException, CertificateException, NoSuchAlgorithmException, CreateException, KeyManagementException {
        this.httpListenerRegistry = new HttpListenerRegistry();
        this.server = NettyHttpServer.builder().withName("test-server").withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withShutdownTimeout(() -> 5000L).withHttpListenerRegistry(this.httpListenerRegistry).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.httpListenerRegistry, "test-server", true, 30000, 10000L, null, (ExecutorService)executorRule.getExecutor())).build();
        this.server.start();
        this.server.addRequestHandler("/saveRequest", (requestContext, responseCallback) -> {
            this.receivedRequests.add(requestContext.getRequest());
            responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().addHeader("HeaderWithCase", "HeaderValue")).build(), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
    }

    @After
    public void tearDown() {
        this.server.stop().dispose();
    }

    @Test
    public void receivedRequestLosesHeaderCaseWhenNoPropertySet() throws IOException, InterruptedException {
        String rawResponse = TestUtils.sendRawRequestToServer(A_RAW_REQUEST_WITH_HEADERS, "localhost", this.serverPort.getNumber());
        HttpRequest requestSeenByServer = this.receivedRequests.take();
        MatcherAssert.assertThat((Object)requestSeenByServer.getHeaderNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"host", "user-agent", "headerwithcase"}));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"headerwithcase"));
    }

    @Test
    public void receivedRequestPreserveHeaderCaseWhenPropertySet() {
        TestUtils.preservingHeaderCase(() -> {
            String rawResponse;
            try {
                rawResponse = TestUtils.sendRawRequestToServer(A_RAW_REQUEST_WITH_HEADERS, "localhost", this.serverPort.getNumber());
                HttpRequest requestSeenByServer = this.receivedRequests.take();
                MatcherAssert.assertThat((Object)requestSeenByServer.getHeaderNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Host", "User-Agent", "HeaderWithCase"}));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"HeaderWithCase"));
        });
    }
}

