/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common;

import java.util.stream.Stream;
import junit.framework.TestCase;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

@ParameterizedClass
@MethodSource(value={"serviceNames"})
public abstract class AbstractHttpServiceTestCase
extends AbstractHttpTestCase
implements ParameterResolver {
    public String serviceToLoad;
    protected HttpService service;
    private SchedulerService schedulerService;

    public AbstractHttpServiceTestCase(String serviceToLoad) {
        this.serviceToLoad = serviceToLoad;
    }

    public static Stream<Arguments> serviceNames() {
        return Stream.of(Arguments.of((Object[])new Object[]{NettyHttpServiceImplementation.class.getName()}));
    }

    @BeforeEach
    public void createServices() throws Exception {
        this.schedulerService = this.getSchedulerService();
        this.service = (HttpService)Class.forName(this.serviceToLoad, true, ((Object)((Object)this)).getClass().getClassLoader()).getConstructor(SchedulerService.class).newInstance(this.schedulerService);
        LifecycleUtils.startIfNeeded((Object)this.service);
    }

    protected SchedulerService getSchedulerService() {
        return new SimpleUnitTestSupportSchedulerService();
    }

    protected String urlForPath(HttpServer httpServer, String endpoint) {
        if (endpoint == null) {
            endpoint = "/";
        }
        if (!((String)endpoint).startsWith("/")) {
            endpoint = "/" + (String)endpoint;
        }
        return String.format("http://%s:%s%s", httpServer.getServerAddress().getIp(), httpServer.getServerAddress().getPort(), endpoint);
    }

    @AfterEach
    public void closeServices() throws Exception {
        if (this.service != null) {
            LifecycleUtils.stopIfNeeded((Object)this.service);
        }
        LifecycleUtils.stopIfNeeded((Object)this.schedulerService);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(String.class) && parameterContext.getParameter().getName().equals("serviceToLoad");
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.serviceToLoad;
    }

    public static final class IgnoreFutureCallback<T>
    implements FutureCallback<T> {
        public void completed(T result) {
        }

        public void failed(Exception ex) {
        }

        public void cancelled() {
        }
    }

    public static class IgnoreResponseStatusCallback
    implements ResponseStatusCallback {
        public void responseSendFailure(Throwable throwable) {
            TestCase.fail((String)throwable.getMessage());
        }

        public void responseSendSuccessfully() {
        }
    }
}

