/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.runtime.connectivity;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Callback used to notify the runtime about the outcome of a reconnection attempt.
 *
 * @since 1.0
 */
@NoImplement
@MinMuleVersion("4.5.0")
public interface ReconnectionCallback {

  /**
   * Notifies the runtime that the connection was successfully reestablished
   */
  void success();

  /**
   * Notifies the runtime that the reconnection attempt failed because of the given {@code exception}
   *
   * @param exception the {@link ConnectionException} for which the reconnection failed
   */
  void failed(ConnectionException exception);
}
