/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.meta;

import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Enumerates the different types of support that a given component can provide regarding expressions
 *
 * @since 1.0
 */
@MinMuleVersion("4.5.0")
public enum ExpressionSupport {
  /**
   * Expressions are required but not enforced. Static values are accepted too.
   */
  @MinMuleVersion("4.5.0")
  SUPPORTED,

  /**
   * Expressions not allowed. Static values only
   */
  @MinMuleVersion("4.5.0")
  NOT_SUPPORTED,

  /**
   * Requires expressions. Static values are not supported
   */
  @MinMuleVersion("4.5.0")
  REQUIRED
}
