/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.semantics.file;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static org.mule.runtime.api.meta.model.display.PathModel.Type.ANY;

import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.display.PathModel.Location;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.param.Parameter;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Marks a field or parameter annotated with {@link Parameter} as a path to a file or directory.
 * <p/>
 * This annotation should only be used with {@link String} parameters.
 *
 * @since 1.0
 */
@Target(value = {PARAMETER, FIELD})
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.4")
@DoNotEnforceMinMuleVersion
public @interface FilePath {

  /**
   * @return whether the path is to a directory or a file
   */
  PathModel.Type type() default ANY;

  /**
   * @return whether the path parameter also supports urls.
   */
  boolean acceptsUrls() default false;

  /**
   * @return a classifier for the path's generic {@link Location}
   */
  Location location() default Location.ANY;

  /**
   * @return the file extensions that this path handles.
   */
  String[] acceptedFileExtensions() default {};
}
