/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;

public class MulePluginArtifactLoaderUtils {
    public static Optional<MulePluginModel> readMulePluginModel(Artifact artifact) {
        Optional<MulePluginModel> result;
        block16: {
            result = Optional.empty();
            if ("mule-plugin".equals(artifact.getClassifier())) {
                try (ZipFile pluginJar = new ZipFile(artifact.getFile());){
                    ZipEntry mulePluginDescriptorEntry = pluginJar.getEntry(MulePluginArtifactLoaderUtils.toZipPath(AbstractMuleMojo.MULE_PLUGIN_JSON_JAR_DESTINATION));
                    if (mulePluginDescriptorEntry == null) break block16;
                    try (InputStream stream = pluginJar.getInputStream(mulePluginDescriptorEntry);){
                        result = Optional.of((MulePluginModel)new MulePluginModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(String.format("Cannot get the file [%s] within the [%s] JAR for the following artifact [%s]", AbstractMuleMojo.MULE_PLUGIN_JSON_JAR_DESTINATION, artifact.getFile().getAbsolutePath(), artifact.toString()), e);
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Cannot get the file [%s] JAR for the following artifact [%s]", artifact.getFile().getAbsolutePath(), artifact.toString()), e);
                }
            }
        }
        return result;
    }

    public static String toZipPath(String filePath) {
        return filePath.replace("\\", "/");
    }
}

