/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation.types;

import java.util.Optional;
import java.util.StringJoiner;
import org.mule.extension.maven.documentation.NameUtils;
import org.mule.extension.maven.documentation.types.TypeFlattener;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.privileged.resources.documentation.XmlExtensionDocumentation;
import org.mule.runtime.module.extension.privileged.resources.documentation.XmlExtensionElementDocumentation;
import org.mule.runtime.module.extension.privileged.resources.documentation.XmlExtensionParameterDocumentation;

class ObjectTypeUtils {
    public static final String EMPTY = "";

    ObjectTypeUtils() {
    }

    static Optional<String> getObjectTypeId(ObjectType objectType) {
        Optional<String> typeName = ObjectTypeUtils.getObjectTypeName(objectType);
        return typeName.map(NameUtils::normalize);
    }

    static Optional<String> getObjectTypeName(ObjectType objectType) {
        Optional id = MetadataTypeUtils.getTypeId((MetadataType)objectType);
        Optional<String> alias = objectType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue);
        if (id.filter(value -> value.startsWith("javax.") || value.startsWith("java.")).isPresent()) {
            return ExtensionMetadataTypeUtils.isInfrastructure((MetadataType)objectType) ? alias : Optional.empty();
        }
        return alias.isPresent() ? alias : id.map(v -> v.contains(".") ? v.substring(v.lastIndexOf(".") + 1) : v);
    }

    static String toAsciidoc(ObjectType type, TypeFlattener flattener, XmlExtensionDocumentation xmlDocumentation) {
        Optional<Object> typeDoc = xmlDocumentation != null && xmlDocumentation.getTypes() != null ? ExtensionMetadataTypeUtils.getId((MetadataType)type).map(id -> xmlDocumentation.getTypes().stream().filter(doc -> doc.getName().equals(id)).findFirst().orElse(null)) : Optional.empty();
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add("[cols=\".^20%,.^25%,.^30%,.^15%,.^10%\", options=\"header\"]");
        stringJoiner.add("|======================");
        stringJoiner.add("| Field | Type | Description | Default Value | Required");
        type.getFields().forEach(field -> {
            String desc = field.getAnnotation(DescriptionAnnotation.class).map(DescriptionAnnotation::getValue).orElseGet(() -> {
                if (typeDoc.isPresent()) {
                    return ((XmlExtensionElementDocumentation)typeDoc.get()).getParameters().stream().filter(p -> p.getName().equals(field.getKey().getName().getLocalPart())).findFirst().map(XmlExtensionParameterDocumentation::getDescription).orElse(EMPTY);
                }
                return EMPTY;
            });
            String localPart = MetadataTypeUtils.getLocalPart((ObjectFieldType)field);
            String defaultValue = field.getAnnotation(DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue).orElse(EMPTY);
            stringJoiner.add(String.format("| %s a| %s | %s | %s | %s", NameUtils.prettify(localPart), flattener.flat(field.getValue()), desc, defaultValue, field.isRequired() ? "x" : EMPTY));
        });
        stringJoiner.add("|======================");
        return stringJoiner.toString();
    }

    static boolean isMessage(ObjectType objectType) {
        Optional typeId = ExtensionMetadataTypeUtils.getId((MetadataType)objectType);
        return typeId.isPresent() && ((String)typeId.get()).equals(Message.class.getName());
    }
}

