/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.loader.PluginDescriptor;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.MavenModelBuilder;
import org.mule.maven.pom.parser.api.model.MavenModelBuilderProvider;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.internal.model.MavenPomModelWrapper;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.util.jar.JarLoadingUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginModelResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MavenProjectExtensionModelLoader {
    private final Log log;

    public MavenProjectExtensionModelLoader(Log log) {
        this.log = log;
    }

    public ExtensionModel loadExtension(MavenProject project, MavenSession session, boolean forceExtensionValidation) throws MojoFailureException, MojoExecutionException {
        String artifactId = project.getArtifactId();
        this.log.debug((CharSequence)String.format("Creating ExtensionModel for:[%s]", artifactId));
        this.configureMavenClient(session);
        Predicate<PluginDescriptor> enableXmlValidations = pluginDescriptor -> pluginDescriptor.getPluginFile().equals(project.getArtifact().getFile()) && "xml-based".equals(pluginDescriptor.getMuleArtifactLoaderDescriptor().getId());
        ArtifactClassLoader muleContainerClassloader = this.createMuleContainerClassloader();
        PluginFileMavenReactor mavenReactor = new PluginFileMavenReactor(project);
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        classLoaderModelAttributes.put("_classLoaderModelMavenReactorResolver", mavenReactor);
        return this.withPluginClassLoaders(project.getArtifact(), classLoaderModelAttributes, muleContainerClassloader, Optional.of(mavenReactor), Optional.of(project.getModel()), enableXmlValidations, artifactClassLoader -> this.doLoadExtensionModel(project.getArtifact(), artifactClassLoader, forceExtensionValidation));
    }

    public ExtensionModel loadExtension(Artifact artifact, MavenSession session, boolean forceExtensionValidation) throws MojoFailureException, MojoExecutionException {
        this.log.debug((CharSequence)String.format("Creating ExtensionModel for:[%s]", artifact.getArtifactId()));
        this.configureMavenClient(session);
        ArtifactClassLoader muleContainerClassloader = this.createMuleContainerClassloader();
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        return this.withPluginClassLoaders(artifact, classLoaderModelAttributes, muleContainerClassloader, Optional.empty(), Optional.empty(), pluginDescriptor -> false, artifactClassLoader -> this.doLoadExtensionModel(artifact, artifactClassLoader, forceExtensionValidation));
    }

    private Set<ExtensionModel> discoverPluginsExtensionModel(MuleDeployableArtifactClassLoader artifactClassLoader, ExtensionModelLoaderRepository extensionModelLoaderRepository, boolean forceExtensionValidation) {
        List artifacts = artifactClassLoader.getArtifactPluginClassLoaders().stream().map(a -> (ArtifactPluginDescriptor)a.getArtifactDescriptor()).collect(Collectors.toList());
        return ExtensionModelDiscoverer.defaultExtensionModelDiscoverer((MuleDeployableArtifactClassLoader)artifactClassLoader, (ExtensionModelLoaderRepository)extensionModelLoaderRepository).discoverPluginsExtensionModels(ExtensionDiscoveryRequest.builder().setArtifactPlugins(artifacts).setForceExtensionValidation(forceExtensionValidation).build());
    }

    private void configureMavenClient(MavenSession session) {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder();
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        MavenExecutionRequest request = session.getRequest();
        mavenConfigurationBuilder.localMavenRepositoryLocation(request.getLocalRepositoryPath());
        mavenConfigurationBuilder.userSettingsLocation(request.getUserSettingsFile());
        mavenConfigurationBuilder.globalSettingsLocation(request.getGlobalSettingsFile());
        settingsSupplierFactory.environmentSettingsSecuritySupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        mavenConfigurationBuilder.userProperties(request.getUserProperties());
        mavenConfigurationBuilder.activeProfiles(request.getActiveProfiles());
        mavenConfigurationBuilder.inactiveProfiles(request.getInactiveProfiles());
        mavenConfigurationBuilder.ignoreArtifactDescriptorRepositories(false);
        GlobalConfigLoader.setMavenConfig((MavenConfiguration)mavenConfigurationBuilder.build());
    }

    private ExtensionModel doLoadExtensionModel(Artifact artifact, MuleDeployableArtifactClassLoader artifactClassLoader, boolean forceExtensionValidation) throws MojoFailureException {
        ExtensionModelLoaderRepository extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager();
        try {
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
        }
        catch (MuleException e) {
            throw new MojoFailureException(String.format("Failure while looking implementation classes of [%s] class through SPI", ExtensionModelLoader.class.getName()), (Throwable)e);
        }
        Set<ExtensionModel> discoverPluginsExtensionModel = this.discoverPluginsExtensionModel(artifactClassLoader, extensionModelLoaderRepository, forceExtensionValidation);
        Optional<ExtensionModel> extensionModelOptional = discoverPluginsExtensionModel.stream().filter(extensionModel -> extensionModel.getArtifactCoordinates().map(artifactCoordinates -> artifactCoordinates.getGroupId().equals(artifact.getGroupId()) && artifactCoordinates.getArtifactId().equals(artifact.getArtifactId()) && artifactCoordinates.getVersion().equals(artifact.getVersion())).orElse(false)).findFirst();
        if (!extensionModelOptional.isPresent()) {
            List foundExtensionModels = discoverPluginsExtensionModel.stream().map(ExtensionModel::getName).collect(Collectors.toList());
            if (foundExtensionModels.isEmpty()) {
                throw new MojoFailureException(String.format("Could not load Extension Model for %s", ArtifactUtils.key((Artifact)artifact)));
            }
            throw new MojoFailureException(String.format("Could not load Extension Model for %s, the following were loaded: %n%s", ArtifactUtils.key((Artifact)artifact), String.join((CharSequence)String.format(", %n", new Object[0]), foundExtensionModels)));
        }
        return extensionModelOptional.get();
    }

    /*
     * Exception decompiling
     */
    private <T> T withPluginClassLoaders(Artifact artifact, Map<String, Object> classLoaderModelLoaderAttributes, ArtifactClassLoader containerArtifactClassLoader, Optional<MavenReactorResolver> mavenReactorResolver, Optional<Model> pomModel, Predicate<PluginDescriptor> enableXmlValidations, Action<T> action) throws MojoFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PluginModelResolver getPluginModelResolver(Predicate<PluginDescriptor> enableXmlValidations) {
        return bundleDependency -> {
            try {
                File pluginFile = new File(bundleDependency.getBundleUri());
                Optional<byte[]> jsonDescriptorContentOptional = Optional.empty();
                String mulePluginJsonPath = "META-INF/mule-artifact/mule-artifact.json";
                jsonDescriptorContentOptional = this.getMuleArtifactJsonDescriptorContent(pluginFile, jsonDescriptorContentOptional, mulePluginJsonPath);
                MulePluginModel artifactModel = jsonDescriptorContentOptional.map(jsonDescriptorContent -> (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(new String((byte[])jsonDescriptorContent, StandardCharsets.UTF_8))).orElseThrow(() -> new ArtifactDescriptorCreateException(String.format("The plugin descriptor '%s' on plugin file '%s' is not present", mulePluginJsonPath, pluginFile)));
                MulePluginModel.MulePluginModelBuilder mulePluginModelBuilder = new MulePluginModel.MulePluginModelBuilder();
                ((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)mulePluginModelBuilder.setName(artifactModel.getName())).setMinMuleVersion("4.1.1")).setRequiredProduct(Product.MULE)).withBundleDescriptorLoader(artifactModel.getBundleDescriptorLoader())).withClassLoaderModelDescriptorLoader(artifactModel.getClassLoaderModelLoaderDescriptor());
                artifactModel.getLicense().ifPresent(licenseModel -> mulePluginModelBuilder.withLicenseModel().setAllowsEvaluationLicense(licenseModel.isAllowsEvaluation()).setProvider(licenseModel.getProvider()).setRequiredEntitlement((String)licenseModel.getRequiredEntitlement().orElse(null)));
                artifactModel.getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptorLoader -> {
                    MuleArtifactLoaderDescriptorBuilder muleArtifactLoaderDescriptorBuilder = mulePluginModelBuilder.withExtensionModelDescriber();
                    muleArtifactLoaderDescriptorBuilder.setId(extensionModelDescriptorLoader.getId());
                    extensionModelDescriptorLoader.getAttributes().entrySet().stream().forEach(entry -> muleArtifactLoaderDescriptorBuilder.addProperty((String)entry.getKey(), entry.getValue()));
                    if (artifactModel.getExtensionModelLoaderDescriptor().isPresent() && enableXmlValidations.test(new PluginDescriptor(pluginFile, (MuleArtifactLoaderDescriptor)artifactModel.getExtensionModelLoaderDescriptor().get()))) {
                        muleArtifactLoaderDescriptorBuilder.addProperty("validate-xml", (Object)true);
                    }
                });
                return mulePluginModelBuilder.build();
            }
            catch (IOException e) {
                throw new ArtifactDescriptorCreateException((Throwable)e);
            }
        };
    }

    private Optional<byte[]> getMuleArtifactJsonDescriptorContent(File pluginFile, Optional<byte[]> jsonDescriptorContentOptional, String mulePluginJsonPath) throws IOException {
        if (pluginFile.isFile()) {
            Preconditions.checkArgument((boolean)pluginFile.getName().endsWith(".jar"), (String)("provided file is not a plugin: " + pluginFile.getAbsolutePath()));
            jsonDescriptorContentOptional = JarLoadingUtils.loadFileContentFrom((File)pluginFile, (String)mulePluginJsonPath);
        } else {
            File mulePluginJsonFile = pluginFile.toPath().resolve(Paths.get("META-INF/mule-artifact", "mule-artifact.json")).toFile();
            if (mulePluginJsonFile.exists()) {
                jsonDescriptorContentOptional = Optional.of(FileUtils.readFileToByteArray((File)mulePluginJsonFile));
            }
        }
        return jsonDescriptorContentOptional;
    }

    private void createPomFile(Artifact artifact, String uuid, File applicationFolder) {
        MavenModelBuilder modelBuilder = MavenModelBuilderProvider.discoverProvider().createMavenModelBuilder(uuid, uuid, MuleManifest.getProductVersion(), Optional.of("4.0.0"), Optional.of("mule-application"));
        BundleDescriptor descriptor = new BundleDescriptor.Builder().setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setVersion(artifact.getVersion()).setClassifier("mule-plugin").setType("jar").build();
        BundleDependency dependency = new BundleDependency.Builder().setBundleDescriptor(descriptor).build();
        modelBuilder.addDependency(dependency);
        modelBuilder.createDeployablePomFile(applicationFolder.toPath());
        MavenPomModel model = modelBuilder.getModel();
        Properties pomProperties = new Properties();
        pomProperties.setProperty("groupId", model.getGroupId());
        pomProperties.setProperty("artifactId", model.getArtifactId());
        pomProperties.setProperty("version", model.getVersion());
        modelBuilder.createDeployablePomProperties(applicationFolder.toPath(), pomProperties);
    }

    private ArtifactClassLoader createMuleContainerClassloader() {
        ModuleRepository moduleRepository = ModuleRepository.createModuleRepository((ClassLoader)this.getClass().getClassLoader(), (File)Files.createTempDir());
        return ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepository, (ClassLoader)this.getClass().getClassLoader());
    }

    private static /* synthetic */ File lambda$withPluginClassLoaders$9(File applicationFolder, String empty) {
        return applicationFolder;
    }

    private static /* synthetic */ Map lambda$withPluginClassLoaders$8(Artifact artifact, Model pom) {
        return Collections.singletonMap(new ArtifactCoordinates(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), () -> new MavenPomModelWrapper(pom));
    }

    @FunctionalInterface
    static interface Action<T> {
        public T call(MuleDeployableArtifactClassLoader var1) throws MojoFailureException, MojoExecutionException;
    }

    class PluginFileMavenReactor
    implements MavenReactorResolver {
        private final MavenProject project;

        public PluginFileMavenReactor(MavenProject project) {
            this.project = project;
        }

        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals("pom")) {
                    return this.project.getFile();
                }
                return this.project.getArtifact().getFile();
            }
            return null;
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return bundleDescriptor.getGroupId().equals(this.project.getArtifact().getGroupId()) && bundleDescriptor.getArtifactId().equals(this.project.getArtifact().getArtifactId()) && bundleDescriptor.getVersion().equals(this.project.getArtifact().getVersion());
        }

        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return Collections.singletonList(this.project.getArtifact().getVersion());
            }
            return Collections.emptyList();
        }
    }
}

