/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.loader.MuleArtifactResourcesRegistry;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;

public class MavenProjectExtensionModelLoader {
    private final Log log;

    public MavenProjectExtensionModelLoader(Log log) {
        this.log = log;
    }

    public ExtensionModel loadExtension(MavenProject project, MavenSession session) throws MojoFailureException, MojoExecutionException {
        String artifactId = project.getArtifactId();
        this.log.debug((CharSequence)String.format("Creating ExtensionModel for:[%s]", artifactId));
        this.configureMavenClient(session);
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(pluginDescriptor -> pluginDescriptor.getPluginFile().equals(project.getArtifact().getFile()) && "xml-based".equals(pluginDescriptor.getMuleArtifactLoaderDescriptor().getId()));
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        classLoaderModelAttributes.put("_classLoaderModelMavenReactorResolver", new PluginFileMavenReactor(project));
        return this.withPluginClassLoaders(project.getArtifact(), classLoaderModelAttributes, muleArtifactResourcesRegistry, artifactClassLoader -> this.doLoadExtensionModel(project.getArtifact(), artifactClassLoader, muleArtifactResourcesRegistry.getContainerArtifactClassLoader()));
    }

    public ExtensionModel loadExtension(Artifact artifact, MavenSession session) throws MojoFailureException, MojoExecutionException {
        this.log.debug((CharSequence)String.format("Creating ExtensionModel for:[%s]", artifact.getArtifactId()));
        this.configureMavenClient(session);
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(pluginDescriptor -> false);
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        return this.withPluginClassLoaders(artifact, classLoaderModelAttributes, muleArtifactResourcesRegistry, artifactClassLoader -> this.doLoadExtensionModel(artifact, artifactClassLoader, muleArtifactResourcesRegistry.getContainerArtifactClassLoader()));
    }

    private Set<ExtensionModel> discoverPluginsExtensionModel(MuleDeployableArtifactClassLoader artifactClassLoader, ExtensionModelLoaderRepository extensionModelLoaderRepository) {
        List artifacts = artifactClassLoader.getArtifactPluginClassLoaders().stream().map(a -> (ArtifactPluginDescriptor)a.getArtifactDescriptor()).collect(Collectors.toList());
        return ExtensionModelDiscoverer.defaultExtensionModelDiscoverer((MuleDeployableArtifactClassLoader)artifactClassLoader, (ExtensionModelLoaderRepository)extensionModelLoaderRepository).discoverPluginsExtensionModels(ExtensionDiscoveryRequest.builder().setArtifactPlugins(artifacts).build());
    }

    private void configureMavenClient(MavenSession session) {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder();
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        MavenExecutionRequest request = session.getRequest();
        mavenConfigurationBuilder.localMavenRepositoryLocation(request.getLocalRepositoryPath());
        mavenConfigurationBuilder.userSettingsLocation(request.getUserSettingsFile());
        mavenConfigurationBuilder.globalSettingsLocation(request.getGlobalSettingsFile());
        settingsSupplierFactory.environmentSettingsSecuritySupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        mavenConfigurationBuilder.userProperties(request.getUserProperties());
        mavenConfigurationBuilder.activeProfiles(request.getActiveProfiles());
        mavenConfigurationBuilder.inactiveProfiles(request.getInactiveProfiles());
        mavenConfigurationBuilder.ignoreArtifactDescriptorRepositories(false);
        GlobalConfigLoader.setMavenConfig((MavenConfiguration)mavenConfigurationBuilder.build());
    }

    private ExtensionModel doLoadExtensionModel(Artifact artifact, MuleDeployableArtifactClassLoader artifactClassLoader, ArtifactClassLoader containerArtifactClassLoader) throws MojoFailureException {
        ExtensionModelLoaderRepository extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager((ClassLoader)containerArtifactClassLoader.getClassLoader());
        try {
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
        }
        catch (MuleException e) {
            throw new MojoFailureException(String.format("Failure while looking implementation classes of [%s] class through SPI", ExtensionModelLoader.class.getName()), (Throwable)e);
        }
        Set<ExtensionModel> discoverPluginsExtensionModel = this.discoverPluginsExtensionModel(artifactClassLoader, extensionModelLoaderRepository);
        Optional<ExtensionModel> extensionModelOptional = discoverPluginsExtensionModel.stream().filter(extensionModel -> extensionModel.getArtifactCoordinates().map(artifactCoordinates -> artifactCoordinates.getGroupId().equals(artifact.getGroupId()) && artifactCoordinates.getArtifactId().equals(artifact.getArtifactId()) && artifactCoordinates.getVersion().equals(artifact.getVersion())).orElse(false)).findFirst();
        if (!extensionModelOptional.isPresent()) {
            List foundExtensionModels = discoverPluginsExtensionModel.stream().map(ExtensionModel::getName).collect(Collectors.toList());
            if (foundExtensionModels.isEmpty()) {
                throw new MojoFailureException(String.format("Could not load Extension Model for %s", ArtifactUtils.key((Artifact)artifact)));
            }
            throw new MojoFailureException(String.format("Could not load Extension Model for %s, the following were loaded: %n%s", ArtifactUtils.key((Artifact)artifact), String.join((CharSequence)String.format(", %n", new Object[0]), foundExtensionModels)));
        }
        return extensionModelOptional.get();
    }

    /*
     * Exception decompiling
     */
    private <T> T withPluginClassLoaders(Artifact artifact, Map<String, Object> classLoaderModelLoaderAttributes, MuleArtifactResourcesRegistry muleArtifactResourcesRegistry, Action<T> action) throws MojoFailureException, MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createPomFile(Artifact artifact, String uuid, File applicationFolder) {
        Model model = new Model();
        model.setGroupId(uuid);
        model.setArtifactId(uuid);
        model.setVersion(MuleManifest.getProductVersion());
        model.setPackaging("mule-application");
        model.setModelVersion("4.0.0");
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setClassifier("mule-plugin");
        dependency.setType("jar");
        model.getDependencies().add(dependency);
        MavenUtils.createDeployablePomFile((File)applicationFolder, (Model)model);
        MavenUtils.createDeployablePomProperties((File)applicationFolder, (Model)model);
    }

    private static /* synthetic */ File lambda$withPluginClassLoaders$7(File applicationFolder, String empty) {
        return applicationFolder;
    }

    @FunctionalInterface
    static interface Action<T> {
        public T call(MuleDeployableArtifactClassLoader var1) throws MojoFailureException, MojoExecutionException;
    }

    class PluginFileMavenReactor
    implements MavenReactorResolver {
        private final MavenProject project;

        public PluginFileMavenReactor(MavenProject project) {
            this.project = project;
        }

        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals("pom")) {
                    return this.project.getFile();
                }
                return this.project.getArtifact().getFile();
            }
            return null;
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return bundleDescriptor.getGroupId().equals(this.project.getArtifact().getGroupId()) && bundleDescriptor.getArtifactId().equals(this.project.getArtifact().getArtifactId()) && bundleDescriptor.getVersion().equals(this.project.getArtifact().getVersion());
        }

        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return Collections.singletonList(this.project.getArtifact().getVersion());
            }
            return Collections.emptyList();
        }
    }
}

