/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.tracer.api.context.SpanContext;
import org.mule.runtime.tracer.api.context.SpanContextAware;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.impl.SafeExecutionUtils;
import org.mule.runtime.tracer.impl.span.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventContextGetDistributedTraceContextMapCommand
implements Command<Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventContextGetDistributedTraceContextMapCommand.class);
    public static final String ERROR_MESSAGE = "Error when starting a injecting distributed trace context to span";
    private final EventContext eventContext;

    public static EventContextGetDistributedTraceContextMapCommand getEventContextGetDistributedTraceContextMapCommand(EventContext eventContext) {
        return new EventContextGetDistributedTraceContextMapCommand(eventContext);
    }

    private EventContextGetDistributedTraceContextMapCommand(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    @Override
    public Map<String, String> execute() {
        return SafeExecutionUtils.safeExecuteWithDefaultOnThrowable(() -> this.doGetDistributedTraceContextMap(this.eventContext), Collections.emptyMap(), "Error on getting distrinuted trace context map", true, LOGGER);
    }

    private Map<String, String> doGetDistributedTraceContextMap(EventContext eventContext) {
        SpanContext spanContext;
        if (eventContext instanceof SpanContextAware && (spanContext = ((SpanContextAware)eventContext).getSpanContext()) != null) {
            return spanContext.getSpan().map(InternalSpan::serializeAsMap).orElse(Collections.emptyMap());
        }
        return Collections.emptyMap();
    }
}

