/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetrySpanExporterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetrySpanExporterUtils.class);
    public static final String EXCEPTION_EVENT_NAME = "exception";
    public static final AttributeKey<String> EXCEPTION_TYPE_KEY = AttributeKey.stringKey((String)"exception.type");
    public static final AttributeKey<String> EXCEPTION_MESSAGE_KEY = AttributeKey.stringKey((String)"exception.message");
    public static final AttributeKey<String> EXCEPTION_STACK_TRACE_KEY = AttributeKey.stringKey((String)"exception.stacktrace");
    public static final AttributeKey<Boolean> EXCEPTION_ESCAPED_KEY = AttributeKey.booleanKey((String)"exception.escaped");
    public static final AttributeKey<String> THREAD_END_NAME_KEY = AttributeKey.stringKey((String)"thread.end.name");
    public static final String EXCEPTIONS_HAVE_BEEN_RECORDED = "Exceptions have been recorded.";
    public static final AttributeKey<String> ARTIFACT_ID = AttributeKey.stringKey((String)"artifact.id");
    public static final AttributeKey<String> ARTIFACT_TYPE = AttributeKey.stringKey((String)"artifact.type");
    public static final String SPAN_KIND = "span.kind.override";
    public static final String STATUS = "status.override";

    private OpenTelemetrySpanExporterUtils() {
    }

    public static String getNameWithoutNamespace(String name) {
        int index = name.lastIndexOf(":");
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static Sampler getSampler(String sampler, String samplerArg) {
        if (sampler == null) {
            throw new IllegalArgumentException("The sampler arg retrieved by configuration cannot be null.");
        }
        switch (sampler) {
            case "always_on": {
                return Sampler.alwaysOn();
            }
            case "always_off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": {
                return Sampler.traceIdRatioBased((double)OpenTelemetrySpanExporterUtils.resolveRatio(samplerArg));
            }
            case "parentbased_always_on": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOn());
            }
            case "parentbased_always_off": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOff());
            }
            case "parentbased_traceidratio": {
                return Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)OpenTelemetrySpanExporterUtils.resolveRatio(samplerArg)));
            }
        }
        throw new IllegalArgumentException(String.format("Sampler not valid. Sampler: %s Arg: %s", sampler, samplerArg));
    }

    private static double resolveRatio(String samplerArg) {
        try {
            return Double.parseDouble(samplerArg);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The ratio is invalid: %s", samplerArg));
        }
    }
}

