/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.mule.runtime.api.profiling.tracing.SpanError;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.mule.runtime.tracer.api.span.error.InternalSpanError;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.impl.MutableMuleTraceState;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporterUtils;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetryTraceIdUtils;
import org.mule.runtime.tracer.exporter.impl.OpentelemetrySpanIdentifier;
import org.mule.runtime.tracer.impl.span.InternalSpan;

public class OpenTelemetrySpanExporter
implements SpanExporter,
SpanData,
ReadableSpan,
Attributes {
    private static final String MULE_INSTRUMENTATION_LIBRARY = "mule";
    private static final String MULE_INSTRUMENTATION_LIBRARY_VERSION = "1.0.0";
    public static final InstrumentationLibraryInfo INSTRUMENTATION_LIBRARY_INFO = InstrumentationLibraryInfo.create((String)"mule", (String)"1.0.0");
    public static final InstrumentationScopeInfo INSTRUMENTATION_SCOPE_INFO = InstrumentationScopeUtil.toInstrumentationScopeInfo((InstrumentationLibraryInfo)INSTRUMENTATION_LIBRARY_INFO);
    public static final int EXPORTER_ATTRIBUTES_BASE_SIZE = 3;
    public static final String TRACE_PARENT_KEY = "traceparent";
    private final boolean isRootSpan;
    private final boolean isPolicySpan;
    private final InternalSpan internalSpan;
    private final String artifactId;
    private final String artifactType;
    private final Map<String, String> rootAttributes = new HashMap<String, String>();
    private final SpanProcessor spanProcessor;
    private final Resource resource;
    private final boolean enableMuleAncestorIdManagement;
    private final InitialExportInfo initialExportInfo;
    private boolean exportable;
    private SpanContext spanContext = SpanContext.getInvalid();
    private SpanContext parentSpanContext = SpanContext.getInvalid();
    private SpanKind spanKind = SpanKind.INTERNAL;
    private StatusData statusData = StatusData.unset();
    private List<EventData> errorEvents = Collections.emptyList();
    private String overriddenSpanName;
    private Set<String> noExportUntil;
    private OpenTelemetrySpanExporter rootSpanExporter = this;
    private String rootName;
    private String endThreadNameValue;
    private MutableMuleTraceState muleTraceState;
    private Sampler sampler;

    public OpenTelemetrySpanExporter(org.mule.runtime.api.profiling.tracing.Span span, InitialSpanInfo initialSpanInfo, String artifactId, String artifactType, SpanProcessor spanProcessor, boolean enableMuleAncestorIdManagement, Resource resource, Sampler sampler) {
        Objects.requireNonNull(span);
        Objects.requireNonNull(initialSpanInfo);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(artifactType);
        Objects.requireNonNull(spanProcessor);
        Objects.requireNonNull(resource);
        this.internalSpan = InternalSpan.getAsInternalSpan((org.mule.runtime.api.profiling.tracing.Span)span);
        this.noExportUntil = initialSpanInfo.getInitialExportInfo().noExportUntil();
        this.isRootSpan = initialSpanInfo.isRootSpan();
        this.isPolicySpan = initialSpanInfo.isPolicySpan();
        this.exportable = initialSpanInfo.getInitialExportInfo().isExportable();
        this.artifactId = artifactId;
        this.artifactType = artifactType;
        this.spanProcessor = spanProcessor;
        this.enableMuleAncestorIdManagement = enableMuleAncestorIdManagement;
        this.resource = resource;
        this.muleTraceState = MutableMuleTraceState.getMutableMuleTraceStateFrom(Collections.emptyMap(), enableMuleAncestorIdManagement);
        this.initialExportInfo = initialSpanInfo.getInitialExportInfo();
        this.sampler = sampler;
        this.createSpanContext();
    }

    public <T> T get(AttributeKey<T> attributeKey) {
        throw new UnsupportedOperationException();
    }

    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> biConsumer) {
        biConsumer.accept(OpenTelemetrySpanExporterUtils.ARTIFACT_ID, this.artifactId);
        biConsumer.accept(OpenTelemetrySpanExporterUtils.ARTIFACT_TYPE, this.artifactType);
        biConsumer.accept(OpenTelemetrySpanExporterUtils.THREAD_END_NAME_KEY, this.endThreadNameValue);
        this.internalSpan.forEachAttribute((key, value) -> biConsumer.accept(AttributeKey.stringKey((String)key), value));
    }

    public int size() {
        return 3 + this.internalSpan.getAttributesCount();
    }

    public boolean isEmpty() {
        return false;
    }

    public Map<AttributeKey<?>, Object> asMap() {
        HashMap attributes = new HashMap();
        this.forEach(attributes::put);
        return attributes;
    }

    public AttributesBuilder toBuilder() {
        throw new UnsupportedOperationException();
    }

    public void export() {
        if (this.exportable && this.spanContext.isSampled()) {
            this.endThreadNameValue = Thread.currentThread().getName();
            this.spanProcessor.onEnd((ReadableSpan)this);
        }
    }

    public void updateNameForExport(String newName) {
        if (this.rootSpanExporter != this) {
            this.rootSpanExporter.updateNameForExport(newName);
        } else {
            this.overriddenSpanName = newName;
        }
    }

    public Map<String, String> exportedSpanAsMap() {
        return OpenTelemetryTraceIdUtils.getDistributedTraceContext(this, this.enableMuleAncestorIdManagement);
    }

    public void setRootName(String rootName) {
        if (this.isRootSpan) {
            this.overriddenSpanName = rootName;
        } else {
            this.rootName = rootName;
        }
    }

    public void setRootAttribute(String rootAttributeKey, String rootAttributeValue) {
        if (this.isRootSpan) {
            this.internalSpan.addAttribute(rootAttributeKey, rootAttributeValue);
        } else {
            this.rootAttributes.put(rootAttributeKey, rootAttributeValue);
        }
    }

    public void updateParentSpanFrom(Map<String, String> serializeAsMap) {
        this.parentSpanContext = OpenTelemetryTraceIdUtils.extractContextFromTraceParent(serializeAsMap.get(TRACE_PARENT_KEY));
        this.muleTraceState = MutableMuleTraceState.getMutableMuleTraceStateFrom(serializeAsMap, this.enableMuleAncestorIdManagement);
        if (this.parentSpanContext.isValid()) {
            String traceId = this.parentSpanContext.getTraceId();
            TraceFlags traceFlags = this.getTraceFlags(traceId, this.parentSpanContext, this);
            this.spanContext = !this.exportable ? SpanContext.create((String)traceId, (String)this.parentSpanContext.getSpanId(), (TraceFlags)traceFlags, (TraceState)this.muleTraceState) : SpanContext.create((String)traceId, (String)this.spanContext.getSpanId(), (TraceFlags)traceFlags, (TraceState)this.muleTraceState);
        }
    }

    private TraceFlags getTraceFlags(String traceId, SpanContext parentContext, OpenTelemetrySpanExporter openTelemetrySpanExporter) {
        SamplingResult samplingResult = openTelemetrySpanExporter.sampler.shouldSample(Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)parentContext)), traceId, openTelemetrySpanExporter.getName(), openTelemetrySpanExporter.spanKind, Attributes.empty(), Collections.emptyList());
        return SamplingDecision.RECORD_AND_SAMPLE.equals((Object)samplingResult.getDecision()) ? TraceFlags.getSampled() : TraceFlags.getDefault();
    }

    public SpanIdentifier getSpanIdentifier() {
        if (this.spanContext.isValid()) {
            return new OpentelemetrySpanIdentifier(this.spanContext.getSpanId(), this.spanContext.getTraceId());
        }
        return SpanIdentifier.INVALID_SPAN_IDENTIFIER;
    }

    public void updateChildSpanExporter(SpanExporter childSpanExporter) {
        if (childSpanExporter instanceof OpenTelemetrySpanExporter) {
            OpenTelemetrySpanExporter childOpenTelemetrySpanExporter = (OpenTelemetrySpanExporter)childSpanExporter;
            this.muleTraceState.propagateRemoteContext(childOpenTelemetrySpanExporter.muleTraceState);
            childOpenTelemetrySpanExporter.initialExportInfo.propagateInitialExportInfo(this.initialExportInfo);
            childOpenTelemetrySpanExporter.update();
            if (!childOpenTelemetrySpanExporter.exportable) {
                childOpenTelemetrySpanExporter.parentSpanContext = this.parentSpanContext;
                childOpenTelemetrySpanExporter.spanContext = this.spanContext;
                childOpenTelemetrySpanExporter.rootSpanExporter = this.rootSpanExporter;
                childOpenTelemetrySpanExporter.noExportUntil = this.noExportUntil;
                childOpenTelemetrySpanExporter.setRootName(this.rootName);
                return;
            }
            if (childOpenTelemetrySpanExporter.isPolicySpan) {
                childOpenTelemetrySpanExporter.rootSpanExporter = this.rootSpanExporter;
            }
            if (this.rootName != null) {
                childOpenTelemetrySpanExporter.setRootName(this.rootName);
                this.rootAttributes.forEach(childOpenTelemetrySpanExporter::setRootAttribute);
            }
            if (!this.noExportUntil.isEmpty() && !this.noExportUntil.contains(OpenTelemetrySpanExporterUtils.getNameWithoutNamespace(childSpanExporter.getSpan().getName()))) {
                childOpenTelemetrySpanExporter.parentSpanContext = this.parentSpanContext;
                childOpenTelemetrySpanExporter.noExportUntil = this.noExportUntil;
                childOpenTelemetrySpanExporter.spanContext = this.spanContext;
                childOpenTelemetrySpanExporter.rootSpanExporter = this.rootSpanExporter;
                childOpenTelemetrySpanExporter.exportable = false;
            }
            if (childOpenTelemetrySpanExporter.parentSpanContext == SpanContext.getInvalid()) {
                childOpenTelemetrySpanExporter.parentSpanContext = this.spanContext;
            }
            String traceId = childOpenTelemetrySpanExporter.spanContext.getTraceId();
            String spanId = childOpenTelemetrySpanExporter.spanContext.getSpanId();
            childOpenTelemetrySpanExporter.spanContext = SpanContext.create((String)traceId, (String)spanId, (TraceFlags)this.getTraceFlags(traceId, childOpenTelemetrySpanExporter.parentSpanContext, childOpenTelemetrySpanExporter), (TraceState)childOpenTelemetrySpanExporter.spanContext.getTraceState());
        }
    }

    private void update() {
        this.exportable = this.initialExportInfo.isExportable();
        this.noExportUntil = this.initialExportInfo.noExportUntil();
        this.createSpanContext();
    }

    private void createSpanContext() {
        if (this.exportable && !this.spanContext.isValid()) {
            String spanId = OpenTelemetryTraceIdUtils.generateSpanId();
            String traceId = OpenTelemetryTraceIdUtils.generateTraceId(InternalSpan.getAsInternalSpan((org.mule.runtime.api.profiling.tracing.Span)this.internalSpan.getParent()));
            TraceFlags traceFlags = this.getTraceFlags(traceId, this.parentSpanContext, this);
            this.spanContext = SpanContext.create((String)traceId, (String)spanId, (TraceFlags)traceFlags, (TraceState)this.muleTraceState);
        }
    }

    public InternalSpan getSpan() {
        return this.internalSpan;
    }

    public String getName() {
        if (this.overriddenSpanName == null) {
            return this.internalSpan.getName();
        }
        return this.overriddenSpanName;
    }

    public SpanKind getKind() {
        return this.spanKind;
    }

    public void onAdditionalAttribute(String key, String value) {
        if (key.equals("span.kind.override")) {
            this.rootSpanExporter.spanKind = SpanKind.valueOf((String)value);
        } else if (key.equals("status.override")) {
            StatusCode statusCode = StatusCode.valueOf((String)value);
            this.rootSpanExporter.statusData = StatusData.create((StatusCode)statusCode, null);
        } else if (this.isPolicySpan && !this.rootSpanExporter.equals(this)) {
            this.rootSpanExporter.internalSpan.addAttribute(key, value);
        }
    }

    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    public SpanContext getParentSpanContext() {
        return this.parentSpanContext;
    }

    public String getParentSpanId() {
        return super.getParentSpanId();
    }

    public StatusData getStatus() {
        return this.statusData;
    }

    public long getStartEpochNanos() {
        return this.internalSpan.getDuration().getStart();
    }

    public Attributes getAttributes() {
        return this;
    }

    public List<EventData> getEvents() {
        return this.errorEvents;
    }

    public void onError(InternalSpanError spanError) {
        this.statusData = StatusData.create((StatusCode)StatusCode.ERROR, (String)"Exceptions have been recorded.");
        Attributes errorAttributes = Attributes.of(OpenTelemetrySpanExporterUtils.EXCEPTION_TYPE_KEY, (Object)spanError.getError().getErrorType().toString(), OpenTelemetrySpanExporterUtils.EXCEPTION_MESSAGE_KEY, (Object)spanError.getError().getDescription(), OpenTelemetrySpanExporterUtils.EXCEPTION_STACK_TRACE_KEY, (Object)InternalSpanError.getInternalSpanError((SpanError)spanError).getErrorStacktrace().toString(), OpenTelemetrySpanExporterUtils.EXCEPTION_ESCAPED_KEY, (Object)spanError.isEscapingSpan());
        this.errorEvents = Collections.singletonList(EventData.create((long)System.currentTimeMillis(), (String)"exception", (Attributes)errorAttributes));
    }

    public List<LinkData> getLinks() {
        return Collections.emptyList();
    }

    public long getEndEpochNanos() {
        return this.internalSpan.getDuration().getEnd();
    }

    public boolean hasEnded() {
        return true;
    }

    public int getTotalRecordedEvents() {
        if (this.errorEvents.isEmpty()) {
            return 0;
        }
        return 1;
    }

    public int getTotalRecordedLinks() {
        return 0;
    }

    public int getTotalAttributeCount() {
        return this.size();
    }

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return INSTRUMENTATION_LIBRARY_INFO;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public String getOverriddenSpanName() {
        return this.overriddenSpanName;
    }

    public SpanData toSpanData() {
        return this;
    }

    public long getLatencyNanos() {
        return 0L;
    }

    public <T> T getAttribute(AttributeKey<T> attributeKey) {
        throw new UnsupportedOperationException();
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return INSTRUMENTATION_SCOPE_INFO;
    }

    public MutableMuleTraceState getTraceState() {
        return this.muleTraceState;
    }
}

