/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetrySpanExporterUtils {
    private static final double DEFAULT_TRACEIDRATIO_SAMPLE_RATIO = 1.0;
    private static final String PARENTBASED_ALWAYS_ON = "parentbased_always_on";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetrySpanExporterUtils.class);
    public static final String ALWAYS_ON_SAMPLER = "always_on";
    public static final String ALWAYS_OFF_SAMPLER = "always_off";
    public static final String TRACEIDRATIO_SAMPLER = "traceidratio";
    public static final String PARENTBASED_ALWAYS_OFF_SAMPLER = "parentbased_always_off";
    public static final String PARENTBASED_TRACEIDRATIO_SAMPLER = "parentbased_traceidratio";
    public static final String EXCEPTION_EVENT_NAME = "exception";
    public static final AttributeKey<String> EXCEPTION_TYPE_KEY = AttributeKey.stringKey((String)"exception.type");
    public static final AttributeKey<String> EXCEPTION_MESSAGE_KEY = AttributeKey.stringKey((String)"exception.message");
    public static final AttributeKey<String> EXCEPTION_STACK_TRACE_KEY = AttributeKey.stringKey((String)"exception.stacktrace");
    public static final AttributeKey<Boolean> EXCEPTION_ESCAPED_KEY = AttributeKey.booleanKey((String)"exception.escaped");
    public static final AttributeKey<String> THREAD_END_NAME_KEY = AttributeKey.stringKey((String)"thread.end.name");
    public static final String EXCEPTIONS_HAVE_BEEN_RECORDED = "Exceptions have been recorded.";
    public static final AttributeKey<String> ARTIFACT_ID = AttributeKey.stringKey((String)"artifact.id");
    public static final AttributeKey<String> ARTIFACT_TYPE = AttributeKey.stringKey((String)"artifact.type");
    public static final String SPAN_KIND = "span.kind.override";
    public static final String STATUS = "status.override";

    private OpenTelemetrySpanExporterUtils() {
    }

    public static String getNameWithoutNamespace(String name) {
        int index = name.lastIndexOf(":");
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static Sampler getSampler(String sampler, String samplerArg) {
        double sampleRatio = 1.0;
        if (samplerArg != null) {
            sampleRatio = Double.parseDouble(samplerArg);
        }
        if (sampler == null) {
            return Sampler.alwaysOn();
        }
        switch (sampler) {
            case "always_on": {
                return Sampler.alwaysOn();
            }
            case "always_off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": {
                return Sampler.traceIdRatioBased((double)sampleRatio);
            }
            case "parentbased_always_on": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOn());
            }
            case "parentbased_always_off": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOff());
            }
            case "parentbased_traceidratio": {
                return Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)sampleRatio));
            }
        }
        LOGGER.error("Unrecognized value for sampler: " + sampler + ". Always on sampler will be used.");
        return Sampler.alwaysOn();
    }
}

