/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.config;

import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;

public class SpanExporterConfigurationUtils {
    private SpanExporterConfigurationUtils() {
    }

    public static void enableBackoffStrategy(Object exporterBuilder, SpanExporterConfiguration spanExporterConfiguration) {
        try {
            Field delegateField = exporterBuilder.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            Method setRetryPolicyMethod = delegateField.get(exporterBuilder).getClass().getDeclaredMethod("setRetryPolicy", RetryPolicy.class);
            setRetryPolicyMethod.setAccessible(true);
            setRetryPolicyMethod.invoke(delegateField.get(exporterBuilder), new RetryPolicyBuilder(spanExporterConfiguration).build());
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)new IllegalArgumentException("Unable to set the RetryPolicy reflectively.", e));
        }
    }

    private static class RetryPolicyBuilder {
        private final SpanExporterConfiguration spanExporterConfiguration;

        public RetryPolicyBuilder(SpanExporterConfiguration spanExporterConfiguration) {
            this.spanExporterConfiguration = spanExporterConfiguration;
        }

        public RetryPolicy build() {
            return RetryPolicy.builder().setBackoffMultiplier(Double.parseDouble(this.spanExporterConfiguration.getStringValue("mule.open.telemetry.exporterbackoff.multiplier"))).setInitialBackoff(Duration.ofSeconds(Long.parseLong(this.spanExporterConfiguration.getStringValue("mule.open.telemetry.exporter.backoff.initial")))).setMaxBackoff(Duration.ofSeconds(Long.parseLong(this.spanExporterConfiguration.getStringValue("mule.open.telemetry.exporterbackoff.max")))).setMaxAttempts(Integer.parseInt(this.spanExporterConfiguration.getStringValue("mule.open.telemetry.exporterbackoff.max.attempts"))).build();
        }
    }
}

