/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.api.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSpanExporterConfiguration
implements SpanExporterConfiguration {
    private final MuleContext muleContext;
    private static final String PROPERTIES_FILE_NAME = "tracer-exporter.conf";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSpanExporterConfiguration.class);
    private ConfigurationPropertiesResolver propertyResolver;
    private Properties properties;
    private ClassLoaderResourceProvider resourceProvider;
    private boolean propertiesInitialised;

    public FileSpanExporterConfiguration(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getStringValue(String key) {
        String value;
        if (!this.propertiesInitialised) {
            this.initialiseProperties();
            this.propertiesInitialised = true;
        }
        if ((value = this.properties.getProperty(key)) != null) {
            String absolutePath;
            value = this.propertyResolver.apply(value);
            if (this.isAValueCorrespondingToAPath(key) && (absolutePath = this.getAbsolutePath(value)) != null) {
                return absolutePath;
            }
            return value;
        }
        return null;
    }

    private String getAbsolutePath(String value) {
        Path path = Paths.get(value, new String[0]);
        try {
            URL url;
            if (!path.isAbsolute() && (url = this.getExecutionClassLoader(this.muleContext).getResource(value)) != null) {
                return new File(url.toURI()).getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            return value;
        }
        return null;
    }

    private boolean isAValueCorrespondingToAPath(String key) {
        return key.equals("mule.open.telemetry.exporter.ca.file.location") || key.equals("mule.open.telemetry.exporter.key.file.location");
    }

    private Properties getSpanExporterConfiguration() {
        try {
            InputStream is = this.resourceProvider.getResourceAsStream(this.getPropertiesFileName());
            return FileSpanExporterConfiguration.loadProperties(is);
        }
        catch (IOException | MuleRuntimeException e) {
            LOGGER.info("No tracer exporter config found in the app or in the conf directory. The config will be retrieved only from the system properties.");
            return System.getProperties();
        }
    }

    protected String getPropertiesFileName() {
        return PROPERTIES_FILE_NAME;
    }

    public static Properties loadProperties(InputStream is) throws IOException {
        if (is == null) {
            I18nMessage error = CoreMessages.objectIsNull((String)"input stream");
            throw new IOException(error.toString());
        }
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }

    protected void initialiseProperties() {
        this.resourceProvider = new ClassLoaderResourceProvider(this.getExecutionClassLoader(this.muleContext));
        this.properties = this.getSpanExporterConfiguration();
        this.propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider());
    }

    protected ClassLoader getExecutionClassLoader(MuleContext muleContext) {
        return muleContext.getExecutionClassLoader();
    }
}

