/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.exception.error;

import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.runtime.soap.api.exception.BadResponseException;
import org.mule.runtime.soap.api.exception.DispatchingException;
import org.mule.runtime.soap.api.exception.EncodingException;
import org.mule.runtime.soap.api.exception.InvalidWsdlException;
import org.mule.runtime.soap.api.exception.SoapFaultException;
import org.mule.runtime.soap.api.exception.error.SoapErrors;

public final class SoapExceptionEnricher {
    public Exception enrich(Exception e) {
        if (e instanceof SoapFaultException) {
            return new ModuleException((ErrorTypeDefinition)SoapErrors.SOAP_FAULT, (Throwable)e);
        }
        if (e instanceof InvalidWsdlException) {
            return new ModuleException((ErrorTypeDefinition)SoapErrors.INVALID_WSDL, (Throwable)e);
        }
        if (e instanceof BadResponseException) {
            return new ModuleException((ErrorTypeDefinition)SoapErrors.BAD_RESPONSE, (Throwable)e);
        }
        if (e instanceof BadRequestException) {
            return new ModuleException((ErrorTypeDefinition)SoapErrors.BAD_REQUEST, (Throwable)e);
        }
        if (e instanceof DispatchingException) {
            return new ModuleException((ErrorTypeDefinition)SoapErrors.CANNOT_DISPATCH, (Throwable)e);
        }
        if (e instanceof EncodingException) {
            return new ModuleException((ErrorTypeDefinition)SoapErrors.ENCODING, (Throwable)e);
        }
        return new Exception("Unexpected error while consuming web service: " + e.getMessage(), e);
    }
}

