/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.utils;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.IdentifiableElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;

public class ArtifactHelperUtils {
    private ArtifactHelperUtils() {
    }

    public static <T extends ParameterizedModel & EnrichableModel> Optional<T> findModel(ExtensionModel extensionModel, IdentifiableElementDeclaration elementDeclaration) {
        Optional<ConfigAwareModel<ConfigAwareModel>> foundModel = ArtifactHelperUtils.findConfigAwareModel(extensionModel, elementDeclaration);
        return foundModel.map(ConfigAwareModel::getModel);
    }

    public static <T extends ParameterizedModel & EnrichableModel> Optional<ConfigAwareModel<T>> findConfigAwareModel(ExtensionModel extensionModel, final IdentifiableElementDeclaration elementDeclaration) {
        final Function<NamedObject, Boolean> equalsName = named -> named.getName().equals(elementDeclaration.getName());
        if (elementDeclaration instanceof TopLevelParameterDeclaration) {
            return Optional.empty();
        }
        final Reference foundModel = new Reference();
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue() && elementDeclaration instanceof ConfigurationElementDeclaration) {
                    foundModel.set(this.configAwareModel(null, model));
                    this.stop();
                }
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue() && elementDeclaration instanceof ConnectionElementDeclaration) {
                    foundModel.set(this.configAwareModel(owner, model));
                    this.stop();
                }
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue() && elementDeclaration instanceof OperationElementDeclaration) {
                    foundModel.set(this.configAwareModel(owner, model));
                    this.stop();
                }
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue() && elementDeclaration instanceof ConstructElementDeclaration) {
                    foundModel.set(this.configAwareModel(owner, model));
                    this.stop();
                }
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                if (((Boolean)equalsName.apply(model)).booleanValue() && elementDeclaration instanceof SourceElementDeclaration) {
                    foundModel.set(this.configAwareModel(owner, model));
                    this.stop();
                }
            }

            private ConfigAwareModel<T> configAwareModel(Object ownerModel, Object model) {
                ParameterizedModel castedModel;
                try {
                    castedModel = (ParameterizedModel)model;
                }
                catch (ClassCastException e) {
                    return null;
                }
                if (ownerModel instanceof ConfigurationModel) {
                    return new ConfigAwareModel(castedModel, (ConfigurationModel)ownerModel, null);
                }
                return new ConfigAwareModel(castedModel, null);
            }
        }.walk(extensionModel);
        return Optional.ofNullable(foundModel.get());
    }

    public static class ConfigAwareModel<T extends ParameterizedModel & EnrichableModel> {
        private final T model;
        private final ConfigurationModel configModel;

        private ConfigAwareModel(T model) {
            this(model, null);
        }

        private ConfigAwareModel(T model, ConfigurationModel configModel) {
            this.model = model;
            this.configModel = configModel;
        }

        public T getModel() {
            return this.model;
        }

        public Optional<ConfigurationModel> getConfigModel() {
            return Optional.ofNullable(this.configModel);
        }

        /* synthetic */ ConfigAwareModel(ParameterizedModel x0, ConfigurationModel x1, 1 x2) {
            this(x0, x1);
        }

        /* synthetic */ ConfigAwareModel(ParameterizedModel x0, 1 x1) {
            this(x0);
        }
    }
}

