/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.metadata;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.MetadataCacheManager;
import org.mule.runtime.module.extension.internal.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.tooling.internal.artifact.ExecutorExceptionWrapper;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataExecutor;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyDeclarationResolver;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyResult;
import org.mule.runtime.module.tooling.internal.artifact.params.ExpressionNotSupportedException;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataComponentExecutor
extends MetadataExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataComponentExecutor.class);

    public MetadataComponentExecutor(ConnectionManager connectionManager, ReflectionCache reflectionCache, ExpressionManager expressionManager, ArtifactHelper artifactHelper, MetadataCacheIdGenerator<ElementDeclaration> metadataCacheIdGenerator, MetadataCacheManager metadataCacheManager) {
        super(connectionManager, reflectionCache, expressionManager, artifactHelper, metadataCacheIdGenerator, metadataCacheManager);
        this.expressionManager = expressionManager;
    }

    public MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentMetadata(ComponentModel componentModel, ComponentElementDeclaration componentElementDeclaration) {
        Object metadataKeyResult;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve component metadata STARTED for component: {}", (Object)componentModel.getName());
            }
            Optional<ConfigurationInstance> optionalConfigurationInstance = this.getConfigurationInstance(componentModel, componentElementDeclaration);
            metadataKeyResult = new MetadataKeyDeclarationResolver(componentModel, componentElementDeclaration, this.expressionManager).resolveKeyResult();
            if (!((MetadataKeyResult)metadataKeyResult).isComplete()) {
                MetadataResult metadataResult = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(((MetadataKeyResult)metadataKeyResult).getPartialReason()).withFailureCode(FailureCode.INVALID_METADATA_KEY).onComponent()});
                return metadataResult;
            }
            MetadataKey metadataKey = ((MetadataKeyResult)metadataKeyResult).getMetadataKey();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invoking connector's component metadata resolver for component: {} with key: {}", (Object)componentModel.getName(), (Object)metadataKey);
            }
            ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader((ExtensionModel)this.artifactHelper.getExtensionModel((ElementDeclaration)componentElementDeclaration));
            MetadataResult<ComponentMetadataTypesDescriptor> metadataResult = this.resolveMetadata(componentElementDeclaration, componentModel, optionalConfigurationInstance, metadataKey, extensionClassLoader);
            return metadataResult;
        }
        catch (MetadataResolvingException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Resolve component metadata has FAILED with code: %s for component: %s", e.getFailure(), componentModel.getName()), (Throwable)e);
            }
            metadataKeyResult = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withFailureCode(e.getFailure()).onComponent()});
            return metadataKeyResult;
        }
        catch (ExpressionNotSupportedException e) {
            metadataKeyResult = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).withFailureCode(FailureCode.INVALID_METADATA_KEY).onKeys()});
            return metadataKeyResult;
        }
        catch (ExecutorExceptionWrapper e) {
            Throwable cause = e.getCause();
            if (cause instanceof MetadataResolvingException) {
                MetadataResolvingException metadataResolvingException = (MetadataResolvingException)cause;
                LOGGER.warn(String.format("Resolve component metadata has FAILED with code: %s for component: %s", metadataResolvingException.getFailure(), componentModel.getName()), cause);
                MetadataResult metadataResult = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withFailureCode(metadataResolvingException.getFailure()).onKeys()});
                return metadataResult;
            }
            Throwables.propagateIfPossible((Throwable)cause, MuleRuntimeException.class);
            throw new MuleRuntimeException(cause);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, MuleRuntimeException.class);
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolve component metadata FINISHED for component: {}", (Object)componentModel.getName());
            }
        }
    }

    @Override
    protected boolean resolverRequiresConfiguration(Optional<TypeResolversInformationModelProperty> typeResolversInformationModelProperty, ComponentModel componentModel) {
        return this.artifactHelper.hasParameterOfType(componentModel, MuleStereotypes.CONFIG);
    }

    private MetadataResult<ComponentMetadataTypesDescriptor> resolveMetadata(ComponentElementDeclaration componentElementDeclaration, ComponentModel componentModel, Optional<ConfigurationInstance> configurationInstance, MetadataKey metadataKey, ClassLoader extensionClassLoader) throws MetadataResolvingException {
        MetadataMediator metadataMediator = new MetadataMediator(componentModel);
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> this.runWithMetadataContext(componentElementDeclaration, configurationInstance, extensionClassLoader, metadataContext -> {
            MetadataResult inputMetadata = metadataMediator.getInputMetadata(metadataContext, metadataKey);
            MetadataResult outputMetadata = null;
            if (componentModel instanceof HasOutputModel) {
                outputMetadata = metadataMediator.getOutputMetadata(metadataContext, metadataKey);
            }
            return this.collectMetadata((MetadataResult<InputMetadataDescriptor>)inputMetadata, outputMetadata);
        }), MetadataResolvingException.class, e -> {
            throw new ExecutorExceptionWrapper(e);
        });
    }

    private MetadataResult<ComponentMetadataTypesDescriptor> collectMetadata(@Nonnull MetadataResult<InputMetadataDescriptor> inputMetadataResult, MetadataResult<OutputMetadataDescriptor> outputMetadataResult) {
        if (inputMetadataResult.isSuccess() && (outputMetadataResult == null || outputMetadataResult.isSuccess())) {
            ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder().withInputMetadataDescriptor((InputMetadataDescriptor)inputMetadataResult.get());
            if (outputMetadataResult != null) {
                builder.withOutputMetadataDescriptor((OutputMetadataDescriptor)outputMetadataResult.get());
            }
            return MetadataResult.success((Object)builder.build());
        }
        ArrayList failures = new ArrayList(inputMetadataResult.getFailures());
        if (outputMetadataResult != null) {
            failures.addAll(outputMetadataResult.getFailures());
        }
        return MetadataResult.failure(failures);
    }
}

