/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.DeployableMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.mule.runtime.module.tooling.api.connectivity.ConnectivityTestingServiceBuilder;
import org.mule.runtime.module.tooling.internal.TemporaryArtifactConnectivityTestingService;

class DefaultConnectivityTestingServiceBuilder
implements ConnectivityTestingServiceBuilder {
    private final DefaultApplicationFactory defaultApplicationFactory;
    private ArtifactDeclaration artifactDeclaration;
    private Model model;

    DefaultConnectivityTestingServiceBuilder(DefaultApplicationFactory defaultApplicationFactory) {
        this.defaultApplicationFactory = defaultApplicationFactory;
        this.createTempMavenModel();
    }

    @Override
    public ConnectivityTestingServiceBuilder addDependency(String groupId, String artifactId, String artifactVersion, String classifier, String type) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(artifactVersion);
        dependency.setType(type);
        dependency.setClassifier(classifier);
        if (!"mule-plugin".equals(classifier)) {
            MavenUtils.addSharedLibraryDependency((Model)this.model, (Dependency)dependency);
        }
        this.model.getDependencies().add(dependency);
        return this;
    }

    private void createTempMavenModel() {
        this.model = new Model();
        this.model.setArtifactId("temp-artifact-id");
        this.model.setGroupId("temp-group-id");
        this.model.setVersion("temp-version");
        this.model.setDependencies(new ArrayList());
        this.model.setModelVersion("4.0.0");
    }

    @Override
    public ConnectivityTestingServiceBuilder setArtifactDeclaration(ArtifactDeclaration artifactDeclaration) {
        this.artifactDeclaration = artifactDeclaration;
        return this;
    }

    @Override
    public ConnectivityTestingService build() {
        Preconditions.checkState((this.artifactDeclaration != null ? 1 : 0) != 0, (String)"artifact configuration cannot be null");
        return new TemporaryArtifactConnectivityTestingService(() -> {
            String applicationName = UUID.getUUID() + "-connectivity-testing-temp-app";
            File applicationFolder = new File(MuleFoldersUtil.getExecutionFolder(), applicationName);
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(applicationName);
            applicationDescriptor.setArtifactDeclaration(this.artifactDeclaration);
            applicationDescriptor.setConfigResources(Collections.emptyList());
            applicationDescriptor.setArtifactLocation(applicationFolder);
            MavenUtils.createDeployablePomFile((File)applicationFolder, (Model)this.model);
            MavenUtils.updateArtifactPom((File)applicationFolder, (Model)this.model);
            MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)DefaultConnectivityTestingServiceBuilder.class.getClassLoader());
            applicationDescriptor.setClassLoaderModel(new DeployableMavenClassLoaderModelLoader(mavenClientProvider.createMavenClient(GlobalConfigLoader.getMavenConfig()), mavenClientProvider.getLocalRepositorySuppliers()).load(applicationFolder));
            return this.defaultApplicationFactory.createArtifact(applicationDescriptor);
        });
    }
}

