/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal;

import java.io.IOException;
import java.util.Collections;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.api.tls.TlsRevocationCheckBuilder;
import org.mule.runtime.module.tls.internal.DefaultTlsContextFactory;
import org.mule.runtime.module.tls.internal.revocation.CrlFile;
import org.mule.runtime.module.tls.internal.revocation.CustomOcspResponder;
import org.mule.runtime.module.tls.internal.revocation.RevocationCheck;
import org.mule.runtime.module.tls.internal.revocation.StandardRevocationCheck;

public class DefaultTlsContextFactoryBuilder
implements TlsContextFactoryBuilder {
    private TlsContextFactory defaultTlsContextFactory;
    private DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory(Collections.emptyMap());
    private String trustStorePath;
    private String keyStorePath;
    private RevocationCheck selectedRevocationCheck;

    public DefaultTlsContextFactoryBuilder(TlsContextFactory defaultTlsContextFactory) {
        this.defaultTlsContextFactory = defaultTlsContextFactory;
    }

    public TlsContextFactoryBuilder name(String name) {
        this.tlsContextFactory.setName(name);
        return this;
    }

    public TlsContextFactoryBuilder enabledProtocols(String protocols) {
        this.tlsContextFactory.setEnabledProtocols(protocols);
        return this;
    }

    public TlsContextFactoryBuilder enabledCipherSuites(String cipherSuites) {
        this.tlsContextFactory.setEnabledCipherSuites(cipherSuites);
        return this;
    }

    public TlsContextFactoryBuilder trustStorePath(String path) {
        this.trustStorePath = path;
        return this;
    }

    public TlsContextFactoryBuilder trustStorePassword(String password) {
        this.tlsContextFactory.setTrustStorePassword(password);
        return this;
    }

    public TlsContextFactoryBuilder trustStoreType(String type) {
        this.tlsContextFactory.setTrustStoreType(type);
        return this;
    }

    public TlsContextFactoryBuilder insecureTrustStore(boolean insecure) {
        this.tlsContextFactory.setTrustStoreInsecure(insecure);
        return this;
    }

    public TlsContextFactoryBuilder trustStoreAlgorithm(String algorithm) {
        this.tlsContextFactory.setTrustManagerAlgorithm(algorithm);
        return this;
    }

    public TlsContextFactoryBuilder keyStorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    public TlsContextFactoryBuilder keyStorePassword(String password) {
        this.tlsContextFactory.setKeyStorePassword(password);
        return this;
    }

    public TlsContextFactoryBuilder keyAlias(String alias) {
        this.tlsContextFactory.setKeyAlias(alias);
        return this;
    }

    public TlsContextFactoryBuilder keyPassword(String password) {
        this.tlsContextFactory.setKeyPassword(password);
        return this;
    }

    public TlsContextFactoryBuilder keyStoreType(String type) {
        this.tlsContextFactory.setKeyStoreType(type);
        return this;
    }

    public TlsContextFactoryBuilder keyStoreAlgorithm(String algorithm) {
        this.tlsContextFactory.setKeyManagerAlgorithm(algorithm);
        return this;
    }

    public TlsRevocationCheckBuilder revocationCheck() {
        final DefaultTlsContextFactoryBuilder contextFactoryBuilder = this;
        return new TlsRevocationCheckBuilder(){

            public TlsContextFactoryBuilder standard(boolean onlyEndEntities, boolean preferCrls, boolean noFallback, boolean softFail) {
                StandardRevocationCheck revocationCheck = new StandardRevocationCheck();
                revocationCheck.setOnlyEndEntities(onlyEndEntities);
                revocationCheck.setPreferCrls(preferCrls);
                revocationCheck.setNoFallback(noFallback);
                revocationCheck.setSoftFail(softFail);
                DefaultTlsContextFactoryBuilder.this.selectedRevocationCheck = revocationCheck;
                return contextFactoryBuilder;
            }

            public TlsContextFactoryBuilder customOcsp(String url, String certAlias) {
                CustomOcspResponder revocationCheck = new CustomOcspResponder();
                revocationCheck.setUrl(url);
                revocationCheck.setCertAlias(certAlias);
                DefaultTlsContextFactoryBuilder.this.selectedRevocationCheck = revocationCheck;
                return contextFactoryBuilder;
            }

            public TlsContextFactoryBuilder crlFile(String path) {
                CrlFile revocationCheck = new CrlFile();
                revocationCheck.setPath(path);
                DefaultTlsContextFactoryBuilder.this.selectedRevocationCheck = revocationCheck;
                return contextFactoryBuilder;
            }
        };
    }

    public TlsContextFactory build() throws CreateException {
        try {
            if (this.trustStorePath != null) {
                this.tlsContextFactory.setTrustStorePath(this.trustStorePath);
            }
            if (this.keyStorePath != null) {
                this.tlsContextFactory.setKeyStorePath(this.keyStorePath);
            }
            if (this.selectedRevocationCheck != null) {
                this.tlsContextFactory.setRevocationCheck(this.selectedRevocationCheck);
            }
            this.tlsContextFactory.initialise();
        }
        catch (IOException e) {
            throw new CreateException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e, (Object)this.tlsContextFactory);
        }
        catch (InitialisationException e) {
            throw new CreateException(e.getI18nMessage(), (Throwable)e, (Object)this.tlsContextFactory);
        }
        return this.tlsContextFactory;
    }

    public TlsContextFactory buildDefault() {
        return this.defaultTlsContextFactory;
    }
}

