/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.core.api.security.tls.RestrictedSSLServerSocketFactory;
import org.mule.runtime.core.api.security.tls.RestrictedSSLSocketFactory;
import org.mule.runtime.core.api.security.tls.TlsConfiguration;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTlsContextFactory
implements TlsContextFactory,
Initialisable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTlsContextFactory.class);
    private static final String DEFAULT = "default";
    private String name;
    private TlsConfiguration tlsConfiguration = new TlsConfiguration(null);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private boolean trustStoreInsecure = false;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;

    public void initialise() throws InitialisationException {
        String[] validCipherSuites;
        String[] globalEnabledCipherSuites;
        String[] validProtocols;
        String[] globalEnabledProtocols;
        if (this.initialized.getAndSet(true)) {
            return;
        }
        try {
            this.tlsConfiguration.initialise(null == this.getKeyStorePath(), null);
        }
        catch (CreateException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Unable to initialise TLS configuration"), (Throwable)e, (Initialisable)this);
        }
        if (!this.isUseDefaults(this.enabledProtocols) && (globalEnabledProtocols = this.tlsConfiguration.getEnabledProtocols()) != null && (validProtocols = ArrayUtils.intersection((String[])this.enabledProtocols, (String[])globalEnabledProtocols)).length < this.enabledProtocols.length) {
            this.globalConfigNotHonored("protocols", globalEnabledProtocols);
        }
        if (!this.isUseDefaults(this.enabledCipherSuites) && (globalEnabledCipherSuites = this.tlsConfiguration.getEnabledCipherSuites()) != null && (validCipherSuites = ArrayUtils.intersection((String[])this.enabledCipherSuites, (String[])globalEnabledCipherSuites)).length < this.enabledCipherSuites.length) {
            this.globalConfigNotHonored("cipher suites", globalEnabledCipherSuites);
        }
    }

    private boolean isUseDefaults(String[] array) {
        return array == null || array.length == 1 && DEFAULT.equalsIgnoreCase(array[0]);
    }

    private void globalConfigNotHonored(String element, String[] elementArray) throws InitialisationException {
        throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("Some selected %1$s are invalid. Valid %1$s according to your TLS configuration file are: %2$s", element, Joiner.on((String)", ").join((Object[])elementArray))), (Initialisable)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyStorePath() {
        return this.tlsConfiguration.getKeyStore();
    }

    public void setKeyStorePath(String name) throws IOException {
        this.tlsConfiguration.setKeyStore(name);
    }

    public String getKeyStoreType() {
        return this.tlsConfiguration.getKeyStoreType();
    }

    public void setKeyStoreType(String keyStoreType) {
        this.tlsConfiguration.setKeyStoreType(keyStoreType);
    }

    public String getKeyAlias() {
        return this.tlsConfiguration.getKeyAlias();
    }

    public void setKeyAlias(String keyAlias) {
        this.tlsConfiguration.setKeyAlias(keyAlias);
    }

    public String getKeyStorePassword() {
        return this.tlsConfiguration.getKeyStorePassword();
    }

    public void setKeyStorePassword(String storePassword) {
        this.tlsConfiguration.setKeyStorePassword(storePassword);
    }

    public String getKeyPassword() {
        return this.tlsConfiguration.getKeyPassword();
    }

    public void setKeyPassword(String keyManagerPassword) {
        this.tlsConfiguration.setKeyPassword(keyManagerPassword);
    }

    public String getKeyManagerAlgorithm() {
        return this.tlsConfiguration.getKeyManagerAlgorithm();
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.tlsConfiguration.setKeyManagerAlgorithm(keyManagerAlgorithm);
    }

    public String getTrustStorePath() {
        return this.tlsConfiguration.getTrustStore();
    }

    public void setTrustStorePath(String trustStorePath) throws IOException {
        String trustStoreResource = FileUtils.getResourcePath((String)trustStorePath, this.getClass());
        if (trustStoreResource == null) {
            throw new IOException(String.format("Resource %s could not be found", trustStorePath));
        }
        this.tlsConfiguration.setTrustStore(trustStorePath);
    }

    public String getTrustStoreType() {
        return this.tlsConfiguration.getTrustStoreType();
    }

    public void setTrustStoreType(String trustStoreType) {
        this.tlsConfiguration.setTrustStoreType(trustStoreType);
    }

    public String getTrustStorePassword() {
        return this.tlsConfiguration.getTrustStorePassword();
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.tlsConfiguration.setTrustStorePassword(trustStorePassword);
    }

    public String getTrustManagerAlgorithm() {
        return this.tlsConfiguration.getTrustManagerAlgorithm();
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.tlsConfiguration.setTrustManagerAlgorithm(trustManagerAlgorithm);
    }

    public boolean isTrustStoreInsecure() {
        return this.trustStoreInsecure;
    }

    public void setTrustStoreInsecure(boolean insecure) {
        if (insecure) {
            logger.warn(String.format("TLS context %s trust store set as insecure. No certificate validations will be performed, rendering connections vulnerable to attacks. Use at own risk.", this.name == null ? "" : this.name));
        }
        this.trustStoreInsecure = insecure;
    }

    public SSLContext createSslContext() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = this.trustStoreInsecure ? this.tlsConfiguration.getSslContext(new TrustManager[]{new InsecureTrustManager()}) : this.tlsConfiguration.getSslContext();
        return sslContext;
    }

    public SSLSocketFactory getSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        return new RestrictedSSLSocketFactory(this.createSslContext(), this.getEnabledCipherSuites(), this.getEnabledProtocols());
    }

    public SSLServerSocketFactory getServerSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        return new RestrictedSSLServerSocketFactory(this.createSslContext(), this.getEnabledCipherSuites(), this.getEnabledProtocols());
    }

    public String[] getEnabledCipherSuites() {
        String[] enabledCipherSuites = this.isUseDefaults(this.enabledCipherSuites) ? this.tlsConfiguration.getEnabledCipherSuites() : this.enabledCipherSuites;
        return enabledCipherSuites != null ? Arrays.copyOf(enabledCipherSuites, enabledCipherSuites.length) : null;
    }

    public void setEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = StringUtils.splitAndTrim((String)enabledCipherSuites, (String)",");
    }

    public String[] getEnabledProtocols() {
        String[] enabledProtocols = this.isUseDefaults(this.enabledProtocols) ? this.tlsConfiguration.getEnabledProtocols() : this.enabledProtocols;
        return enabledProtocols != null ? Arrays.copyOf(enabledProtocols, enabledProtocols.length) : null;
    }

    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = StringUtils.splitAndTrim((String)enabledProtocols, (String)",");
    }

    public boolean isKeyStoreConfigured() {
        return this.tlsConfiguration.getKeyStore() != null;
    }

    public boolean isTrustStoreConfigured() {
        return this.tlsConfiguration.getTrustStore() != null;
    }

    public TlsContextKeyStoreConfiguration getKeyStoreConfiguration() {
        return new TlsContextKeyStoreConfiguration(){

            public String getAlias() {
                return DefaultTlsContextFactory.this.getKeyAlias();
            }

            public String getKeyPassword() {
                return DefaultTlsContextFactory.this.getKeyPassword();
            }

            public String getPath() {
                return DefaultTlsContextFactory.this.getKeyStorePath();
            }

            public String getPassword() {
                return DefaultTlsContextFactory.this.getKeyStorePassword();
            }

            public String getType() {
                return DefaultTlsContextFactory.this.getKeyStoreType();
            }

            public String getAlgorithm() {
                return DefaultTlsContextFactory.this.getKeyManagerAlgorithm();
            }
        };
    }

    public TlsContextTrustStoreConfiguration getTrustStoreConfiguration() {
        return new TlsContextTrustStoreConfiguration(){

            public String getPath() {
                return DefaultTlsContextFactory.this.getTrustStorePath();
            }

            public String getPassword() {
                return DefaultTlsContextFactory.this.getTrustStorePassword();
            }

            public String getType() {
                return DefaultTlsContextFactory.this.getTrustStoreType();
            }

            public String getAlgorithm() {
                return DefaultTlsContextFactory.this.getTrustManagerAlgorithm();
            }

            public boolean isInsecure() {
                return DefaultTlsContextFactory.this.isTrustStoreInsecure();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultTlsContextFactory)) {
            return false;
        }
        DefaultTlsContextFactory that = (DefaultTlsContextFactory)o;
        return this.tlsConfiguration.equals((Object)that.tlsConfiguration);
    }

    public int hashCode() {
        return this.tlsConfiguration.hashCode();
    }

    private static class InsecureTrustManager
    implements X509TrustManager {
        private InsecureTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

