/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.privileged.spring;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.Optional;
import net.bytebuddy.asm.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.SpringVersion;

public class ByteBuddySpringCachesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteBuddySpringCachesManager.class);
    public static final Cache<Object, Optional<?>> springCaches = Caffeine.newBuilder().weakKeys().build();

    public static void clearCaches() throws Exception {
        SpringVersion.class.getClassLoader().loadClass(ByteBuddySpringCachesManager.class.getName()).getMethod("doClearCaches", new Class[0]).invoke(null, new Object[0]);
    }

    public static void doClearCaches() {
        springCaches.cleanUp();
        LOGGER.debug("Cleaning up {} Spring caches", (Object)springCaches.estimatedSize());
        springCaches.asMap().keySet().forEach(ByteBuddySpringCachesManager::clearCache);
    }

    private static void clearCache(Object springCache) {
        ((Map)springCache).clear();
    }

    @Advice.OnMethodExit(inline=false)
    public static void onMethodExit(@Advice.This Object springCache) {
        LOGGER.debug("Spring cache intercepted - Hash[{}]", (Object)springCache.hashCode());
        springCaches.put(springCache, Optional.empty());
    }
}

