/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.bean.lazy;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.config.internal.context.lazy.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.sdk.api.data.sample.SampleDataException;

public class LazySampleDataService
implements SampleDataService,
Initialisable {
    public static final String NON_LAZY_SAMPLE_DATA_SERVICE = "_muleNonLazySampleDataService";
    private final Supplier<SampleDataService> sampleDataServiceSupplier;
    private final LazyComponentInitializerAdapter lazyComponentInitializer;
    @Inject
    @Named(value="_muleNonLazySampleDataService")
    private SampleDataService sampleDataService;

    public LazySampleDataService(LazyComponentInitializerAdapter lazyComponentInitializer, Supplier<SampleDataService> sampleDataServiceSupplier) {
        this.lazyComponentInitializer = lazyComponentInitializer;
        this.sampleDataServiceSupplier = sampleDataServiceSupplier;
    }

    public void initialise() throws InitialisationException {
        this.sampleDataService = this.sampleDataServiceSupplier.get();
    }

    public Message getSampleData(Location location) throws SampleDataException {
        try {
            this.lazyComponentInitializer.initializeComponent(location, false);
        }
        catch (Exception e) {
            Throwable rootException = ExceptionHelper.getRootException((Throwable)e);
            if (rootException instanceof NoSuchComponentModelException) {
                throw new SampleDataException(e.getMessage(), "INVALID_LOCATION", (Throwable)e);
            }
            throw e;
        }
        return this.sampleDataService.getSampleData(location);
    }

    public Message getSampleData(String extensionName, String componentName, Map<String, Object> parameters, Supplier<Optional<ConfigurationInstance>> configurationInstanceSupplier) throws SampleDataException {
        return this.sampleDataService.getSampleData(extensionName, componentName, parameters, configurationInstanceSupplier);
    }
}

