/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.ParameterValueVisitor;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.internal.component.config.InternalComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InfrastructureElementModelDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfrastructureElementModelDelegate.class);
    private final Set<String> eeStreamingStrategies = ImmutableSet.of((Object)"repeatable-file-store-stream", (Object)"repeatable-file-store-iterable");

    InfrastructureElementModelDelegate() {
    }

    public void addParameter(final String parameterName, ParameterValue value, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final InternalComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement, DslResolvingContext context, DslSyntaxResolver dsl) {
        switch (parameterName) {
            case "reconnection": {
                this.createReconnectionConfig(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "reconnectionStrategy": {
                this.createReconnectionStrategy(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "expirationPolicy": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)value, "expiration-policy", paramDsl.getNamespace());
                return;
            }
            case "streamingStrategy": {
                this.createStreamingStrategy(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "redeliveryPolicy": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)value, "redelivery-policy", paramDsl.getNamespace());
                return;
            }
            case "poolingProfile": {
                this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, (ParameterObjectValue)value, "pooling-profile", paramDsl.getNamespace());
                return;
            }
            case "tlsContext": {
                this.createTlsContext(value, parameterModel, paramDsl, parentConfig, parentElement);
                return;
            }
            case "schedulingStrategy": {
                this.createSchedulingStrategy((ParameterObjectValue)value, parameterModel, paramDsl, parentConfig, parentElement, context, dsl);
                return;
            }
        }
        value.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(ParameterSimpleValue text) {
                parentConfig.withParameter(parameterName, text.getValue());
                parentElement.containing(DslElementModel.builder().withModel((Object)parameterModel).withDsl(paramDsl).withValue(text.getValue()).build());
            }
        });
    }

    private void createSchedulingStrategy(ParameterObjectValue value, ParameterModel parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, DslResolvingContext context, DslSyntaxResolver dsl) {
        InternalComponentConfiguration.Builder schedulingWrapperConfig = InternalComponentConfiguration.builder().withIdentifier(ApplicationModel.SCHEDULING_STRATEGY_IDENTIFIER);
        DslElementModel.Builder schedulingElement = DslElementModel.builder().withDsl(paramDsl).withModel((Object)parameterModel);
        context.getTypeCatalog().getType(value.getTypeId()).ifPresent(strategyType -> dsl.resolve((MetadataType)strategyType).ifPresent(strategyDsl -> {
            InternalComponentConfiguration.Builder strategyConfig = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace("mule").name(strategyDsl.getElementName()).build());
            this.cloneParameters(value, strategyConfig);
            ComponentConfiguration strategy = strategyConfig.build();
            schedulingWrapperConfig.withNestedComponent(strategy);
            ComponentConfiguration schedulingWrapper = schedulingWrapperConfig.build();
            schedulingElement.withConfig(schedulingWrapper).containing(DslElementModel.builder().withModel(strategyType).withDsl(strategyDsl).withConfig(strategy).build());
            parentConfig.withNestedComponent(schedulingWrapper);
            parentElement.containing(schedulingElement.build());
        }));
    }

    private void createTlsContext(ParameterValue value, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final InternalComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        value.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(ParameterSimpleValue text) {
                parentConfig.withParameter("tlsContext", text.getValue());
                parentElement.containing(DslElementModel.builder().withModel((Object)parameterModel).withDsl(paramDsl).build());
            }

            public void visitObjectValue(ParameterObjectValue objectValue) {
                final InternalComponentConfiguration.Builder tlsConfig = InternalComponentConfiguration.builder().withIdentifier(ApplicationModel.TLS_CONTEXT_IDENTIFIER);
                objectValue.getParameters().forEach((name, value) -> value.accept(new ParameterValueVisitor((String)name){
                    final /* synthetic */ String val$name;
                    {
                        this.val$name = string;
                    }

                    public void visitSimpleValue(ParameterSimpleValue text) {
                        tlsConfig.withParameter(this.val$name, text.getValue());
                    }

                    public void visitObjectValue(ParameterObjectValue objectValue) {
                        if (!("key-store".equals(this.val$name) || "trust-store".equals(this.val$name) || "revocation-check".equals(this.val$name))) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(String.format("Skipping unknown parameter with name [%s] for TLSContext", this.val$name));
                            }
                            return;
                        }
                        InternalComponentConfiguration.Builder innerComponent = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace("tls").name(this.val$name).build());
                        if ("revocation-check".equals(this.val$name)) {
                            InfrastructureTypeMapping.getQName((String)objectValue.getTypeId()).map(QNameModelProperty::getValue).ifPresent(qname -> {
                                InternalComponentConfiguration.Builder nested = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace(qname.getPrefix()).name(qname.getLocalPart()).build());
                                InfrastructureElementModelDelegate.this.cloneParameters(objectValue, nested);
                                innerComponent.withNestedComponent(nested.build());
                            });
                        } else {
                            InfrastructureElementModelDelegate.this.cloneParameters(objectValue, innerComponent);
                        }
                        tlsConfig.withNestedComponent(innerComponent.build());
                    }
                }));
                InfrastructureElementModelDelegate.this.addParameterElement(parameterModel, paramDsl, parentConfig, parentElement, tlsConfig.build());
            }
        });
    }

    private void createReconnectionConfig(ParameterValue value, ParameterModel parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        final InternalComponentConfiguration.Builder config = InternalComponentConfiguration.builder().withIdentifier(ApplicationModel.RECONNECTION_CONFIG_PARAMETER_IDENTIFIER);
        DslElementModel.Builder elementBuilder = DslElementModel.builder().withModel((Object)parameterModel).withDsl(paramDsl);
        ((ParameterObjectValue)value).getParameters().forEach((name, fieldValue) -> fieldValue.accept(new ParameterValueVisitor((String)name, (ParameterValue)fieldValue, parameterModel, paramDsl, elementBuilder){
            final /* synthetic */ String val$name;
            final /* synthetic */ ParameterValue val$fieldValue;
            final /* synthetic */ ParameterModel val$parameterModel;
            final /* synthetic */ DslElementSyntax val$paramDsl;
            final /* synthetic */ DslElementModel.Builder val$elementBuilder;
            {
                this.val$name = string;
                this.val$fieldValue = parameterValue;
                this.val$parameterModel = parameterModel;
                this.val$paramDsl = dslElementSyntax;
                this.val$elementBuilder = builder2;
            }

            public void visitSimpleValue(ParameterSimpleValue text) {
                config.withParameter(this.val$name, text.getValue());
            }

            public void visitObjectValue(ParameterObjectValue objectValue) {
                if (this.val$name.equals("reconnectionStrategy")) {
                    InfrastructureElementModelDelegate.this.createReconnectionStrategy(this.val$fieldValue, ((ObjectType)this.val$parameterModel.getType()).getFieldByName("reconnectionStrategy").get(), (DslElementSyntax)this.val$paramDsl.getContainedElement("reconnectionStrategy").get(), config, this.val$elementBuilder);
                }
            }
        }));
        ComponentConfiguration result = config.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(elementBuilder.withConfig(result).build());
    }

    private void createReconnectionStrategy(ParameterValue value, Object parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ParameterObjectValue objectValue = (ParameterObjectValue)value;
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)objectValue.getTypeId()) ? 1 : 0) != 0, (String)"Missing declaration of which reconnection to use");
        String elementName = objectValue.getTypeId().equals("reconnect") ? "reconnect" : "reconnect-forever";
        this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, objectValue, elementName, paramDsl.getNamespace());
    }

    private void createStreamingStrategy(ParameterValue value, ParameterModel parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ParameterObjectValue objectValue = (ParameterObjectValue)value;
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)objectValue.getTypeId()) ? 1 : 0) != 0, (String)"Missing declaration of which streaming strategy to use");
        String namespace = this.eeStreamingStrategies.contains(objectValue.getTypeId()) ? "ee" : "mule";
        this.cloneDeclarationToElement(parameterModel, paramDsl, parentConfig, parentElement, objectValue, objectValue.getTypeId(), namespace);
    }

    private void cloneDeclarationToElement(Object parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ParameterObjectValue objectValue, String elementName, String customNamespace) {
        InternalComponentConfiguration.Builder config = InternalComponentConfiguration.builder().withIdentifier(ComponentIdentifier.builder().namespace(StringUtils.isBlank((CharSequence)customNamespace) ? "mule" : customNamespace).name(elementName).build());
        this.cloneParameters(objectValue, config);
        this.addParameterElement(parameterModel, paramDsl, parentConfig, parentElement, config.build());
    }

    private void addParameterElement(Object parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ComponentConfiguration result) {
        parentConfig.withNestedComponent(result);
        parentElement.containing(DslElementModel.builder().withModel(parameterModel).withDsl(paramDsl).withConfig(result).build());
    }

    private void cloneParameters(ParameterObjectValue objectValue, final InternalComponentConfiguration.Builder config) {
        objectValue.getParameters().forEach((name, value) -> value.accept(new ParameterValueVisitor((String)name){
            final /* synthetic */ String val$name;
            {
                this.val$name = string;
            }

            public void visitSimpleValue(ParameterSimpleValue text) {
                config.withParameter(this.val$name, text.getValue());
            }
        }));
    }
}

