/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.internal.MetadataInvocationHandler;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.config.preferred.PreferredObjectSelector;

public class InjectParamsFromContextServiceProxy
extends MetadataInvocationHandler<Service> {
    public static final String MANY_CANDIDATES_ERROR_MSG_TEMPLATE = "More than one invocation candidate for method '%s' in service '%s'";
    public static final String NO_OBJECT_FOUND_FOR_PARAM = "No object found in the registry for parameter '%s' of method '%s' in service '%s'";
    private final Registry registry;
    private LoadingCache<Class<?>, Collection<?>> lookupAllByTypeCache;
    private LoadingCache<String, Optional<?>> lookupByNameCache;

    public InjectParamsFromContextServiceProxy(Service service, Registry registry) {
        super((Object)service);
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (String)"context cannot be null");
        this.registry = registry;
        this.lookupAllByTypeCache = Caffeine.newBuilder().build(arg_0 -> ((Registry)registry).lookupAllByType(arg_0));
        this.lookupByNameCache = Caffeine.newBuilder().build(arg_0 -> ((Registry)registry).lookupByName(arg_0));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method injectable = this.resolveInjectableMethod(method);
        if (injectable == null) {
            return this.doInvoke(proxy, method, args);
        }
        ArrayList<Object> augmentedArgs = args == null ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(args));
        for (int i = method.getParameters().length; i < injectable.getParameters().length; ++i) {
            Object arg;
            Parameter parameter = injectable.getParameters()[i];
            if (parameter.isAnnotationPresent(Named.class)) {
                arg = ((Optional)this.lookupByNameCache.get((Object)parameter.getAnnotation(Named.class).value())).orElseThrow(() -> new IllegalDependencyInjectionException(String.format(NO_OBJECT_FOUND_FOR_PARAM, parameter.getName(), injectable.getName(), ((Service)this.getProxiedObject()).getName())));
            } else {
                Collection lookupObjects = (Collection)this.lookupAllByTypeCache.get(parameter.getType());
                arg = new PreferredObjectSelector().select(lookupObjects.iterator());
            }
            augmentedArgs.add(arg);
        }
        return this.doInvoke(proxy, injectable, augmentedArgs.toArray());
    }

    private Method resolveInjectableMethod(Method method) {
        Method candidate = null;
        for (Method serviceImplMethod : this.getImplementationDeclaredMethods()) {
            if (!Modifier.isPublic(serviceImplMethod.getModifiers()) || !serviceImplMethod.getName().equals(method.getName()) || ((Inject[])serviceImplMethod.getAnnotationsByType(Inject.class)).length <= 0 || !this.equivalentParams(method.getParameters(), serviceImplMethod.getParameters())) continue;
            if (!(candidate == null || candidate.getName().equals(serviceImplMethod.getName()) && Arrays.deepEquals(candidate.getParameterTypes(), serviceImplMethod.getParameterTypes()))) {
                throw new IllegalDependencyInjectionException(String.format(MANY_CANDIDATES_ERROR_MSG_TEMPLATE, method.getName(), ((Service)this.getProxiedObject()).getName()));
            }
            candidate = serviceImplMethod;
        }
        return candidate;
    }

    private boolean equivalentParams(Parameter[] invocationParams, Parameter[] serviceImplParams) {
        int i = 0;
        for (Parameter invocationParam : invocationParams) {
            if (i >= serviceImplParams.length || !serviceImplParams[i].getType().equals(invocationParam.getType())) {
                return false;
            }
            ++i;
        }
        for (int j = i; j < serviceImplParams.length; ++j) {
            if (serviceImplParams[j].isAnnotationPresent(Named.class) || !((Collection)this.lookupAllByTypeCache.get(serviceImplParams[j].getType())).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static Service createInjectProviderParamsServiceProxy(Service service, Registry registry) {
        Preconditions.checkArgument((service != null ? 1 : 0) != 0, (String)"service cannot be null");
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (String)"registry cannot be null");
        InjectParamsFromContextServiceProxy handler = new InjectParamsFromContextServiceProxy(service, registry);
        return (Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), ClassUtils.findImplementedInterfaces(service.getClass()), (InvocationHandler)((Object)handler));
    }
}

