/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.ParameterValueVisitor;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.ReferableElementDeclaration;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.config.internal.dsl.model.InfrastructureElementModelDelegate;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.internal.component.config.InternalComponentConfiguration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntaxBuilder;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeclarationBasedElementModelFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeclarationBasedElementModelFactory.class);
    private final DslResolvingContext context;
    private final InfrastructureElementModelDelegate infrastructureDelegate;
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final Map<ExtensionModel, DslSyntaxResolver> resolvers;
    private ExtensionModel currentExtension;
    private DslSyntaxResolver dsl;

    DeclarationBasedElementModelFactory(DslResolvingContext context, Map<ExtensionModel, DslSyntaxResolver> resolvers) {
        this.context = context;
        this.resolvers = resolvers;
        this.infrastructureDelegate = new InfrastructureElementModelDelegate();
    }

    public <T> Optional<DslElementModel<T>> create(final ElementDeclaration declaration) {
        this.setupCurrentExtensionContext(declaration.getDeclaringExtension());
        final Predicate<NamedObject> equalsName = named -> named.getName().equals(declaration.getName());
        if (declaration instanceof TopLevelParameterDeclaration) {
            return this.createFromType((TopLevelParameterDeclaration)declaration);
        }
        final Reference elementModel = new Reference();
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                if (equalsName.test(model) && declaration instanceof ConfigurationElementDeclaration) {
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createConfigurationElement(model, (ConfigurationElementDeclaration)declaration));
                    this.stop();
                }
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                if (equalsName.test(model) && declaration instanceof ConnectionElementDeclaration) {
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createConnectionProviderModel(model, (ConnectionElementDeclaration)declaration));
                    this.stop();
                }
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (equalsName.test(model) && declaration instanceof OperationElementDeclaration) {
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createComponentElement((ComponentModel)model, (ComponentElementDeclaration)((OperationElementDeclaration)declaration)));
                    this.stop();
                }
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                if (equalsName.test(model) && declaration instanceof ConstructElementDeclaration) {
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createComponentElement((ComponentModel)model, (ComponentElementDeclaration)((ConstructElementDeclaration)declaration)));
                    this.stop();
                }
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                if (equalsName.test(model) && declaration instanceof SourceElementDeclaration) {
                    elementModel.set((Object)DeclarationBasedElementModelFactory.this.createComponentElement((ComponentModel)model, (ComponentElementDeclaration)((SourceElementDeclaration)declaration)));
                    this.stop();
                }
            }
        }.walk(this.currentExtension);
        if (LOGGER.isDebugEnabled() && elementModel.get() == null) {
            LOGGER.debug(String.format("No model found with name [%s] of type [%s] for extension [%s]", declaration.getName(), declaration.getClass().getName(), declaration.getDeclaringExtension()));
        }
        return Optional.ofNullable(elementModel.get());
    }

    public <T> Optional<DslElementModel<T>> create(ComponentModel parentModel, ComponentElementDeclaration childDeclaration) {
        return parentModel.getNestedComponents().stream().filter(nestedComponent -> nestedComponent.getName().equals(childDeclaration.getName())).findFirst().map(nestedComponentModel -> this.createComponentElement((ComponentModel)nestedComponentModel, childDeclaration));
    }

    private <T> Optional<DslElementModel<T>> createFromType(TopLevelParameterDeclaration declaration) {
        return this.context.getTypeCatalog().getType(declaration.getValue().getTypeId()).map(objectType -> this.createTopLevelElement((ObjectType)objectType, declaration));
    }

    private DslElementModel<ConfigurationModel> createConfigurationElement(ConfigurationModel model, ConfigurationElementDeclaration configDeclaration) {
        DslElementSyntax configDsl = this.dsl.resolve((NamedObject)model);
        InternalComponentConfiguration.Builder configuration = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(configDsl)).withParameter("name", configDeclaration.getRefName());
        DslElementModel.Builder element = DslElementModel.builder().withModel((Object)model).withDsl(configDsl);
        configDeclaration.getConnection().ifPresent(connection -> this.addConnectionProvider((ConnectionElementDeclaration)connection, model, configuration, (DslElementModel.Builder<ConfigurationModel>)element));
        this.enrichParameterizedElementModel(model, configDsl, (ParameterizedElementDeclaration)configDeclaration, configuration, element);
        return element.withConfig(configuration.build()).build();
    }

    private DslElementModel<? extends ComponentModel> createComponentElement(ComponentModel model, ComponentElementDeclaration<?> componentDeclaration) {
        DslElementSyntax configDsl = this.dsl.resolve((NamedObject)model);
        InternalComponentConfiguration.Builder configuration = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(configDsl));
        if (componentDeclaration instanceof ReferableElementDeclaration) {
            model.getAllParameterModels().stream().filter(ParameterModel::isComponentId).findAny().ifPresent(pm -> configuration.withParameter(pm.getName(), ((ReferableElementDeclaration)componentDeclaration).getRefName()));
        }
        if (componentDeclaration.getConfigRef() != null) {
            configuration.withParameter("config-ref", componentDeclaration.getConfigRef());
        }
        DslElementModel.Builder<ComponentModel> componentElement = this.createParameterizedElementModel((ParameterizedModel)model, configDsl, (ParameterizedElementDeclaration)componentDeclaration, configuration);
        ExtensionModel componentsOwner = this.currentExtension;
        DslSyntaxResolver componentsDslResolver = this.dsl;
        componentDeclaration.getComponents().forEach(nestedComponentDeclaration -> {
            if (nestedComponentDeclaration instanceof RouteElementDeclaration) {
                if (model instanceof ComposableModel) {
                    model.getNestedComponents().stream().filter(nestedModel -> nestedModel instanceof NestedRouteModel && nestedModel.getName().equals(nestedComponentDeclaration.getName())).findFirst().ifPresent(nestedRouteModel -> componentElement.containing(this.crateRouteElement((NestedRouteModel)nestedRouteModel, (RouteElementDeclaration)nestedComponentDeclaration)));
                }
            } else {
                DslElementModel nestedComponentElement = this.create((ElementDeclaration)nestedComponentDeclaration).orElseGet(() -> this.create(model, (ComponentElementDeclaration)nestedComponentDeclaration).orElse(null));
                if (nestedComponentElement != null) {
                    nestedComponentElement.getConfiguration().ifPresent(arg_0 -> ((InternalComponentConfiguration.Builder)configuration).withNestedComponent(arg_0));
                    componentElement.containing(nestedComponentElement);
                }
            }
            this.currentExtension = componentsOwner;
            this.dsl = componentsDslResolver;
        });
        return componentElement.withConfig(configuration.build()).build();
    }

    private DslElementModel<? extends NestedRouteModel> crateRouteElement(NestedRouteModel model, RouteElementDeclaration routeDeclaration) {
        DslElementSyntax routeDsl = this.dsl.resolve((NamedObject)model);
        InternalComponentConfiguration.Builder routeConfiguration = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(routeDsl));
        DslElementModel.Builder<NestedRouteModel> routeElement = this.createParameterizedElementModel(model, routeDsl, (ParameterizedElementDeclaration)routeDeclaration, routeConfiguration);
        ExtensionModel routerOwner = this.currentExtension;
        DslSyntaxResolver routerDslResolver = this.dsl;
        routeDeclaration.getComponents().forEach(componentDeclaration -> {
            this.create((ElementDeclaration)componentDeclaration).ifPresent(componentElement -> {
                componentElement.getConfiguration().ifPresent(arg_0 -> ((InternalComponentConfiguration.Builder)routeConfiguration).withNestedComponent(arg_0));
                routeElement.containing(componentElement);
            });
            this.currentExtension = routerOwner;
            this.dsl = routerDslResolver;
        });
        return routeElement.withConfig(routeConfiguration.build()).build();
    }

    private DslElementModel createTopLevelElement(ObjectType model, TopLevelParameterDeclaration declaration) {
        DslElementSyntax objectDsl = (DslElementSyntax)this.dsl.resolve((MetadataType)model).orElseThrow(() -> new IllegalArgumentException("Failed to resolve the DSL syntax for type '" + ExtensionMetadataTypeUtils.getId((MetadataType)model) + "'"));
        DslElementModel.Builder parentElement = DslElementModel.builder().withModel((Object)model).withDsl(objectDsl);
        InternalComponentConfiguration.Builder configuration = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(objectDsl)).withParameter("name", declaration.getRefName());
        this.populateObjectElementFields(model, declaration.getValue(), objectDsl, configuration, parentElement);
        return parentElement.withConfig(configuration.build()).build();
    }

    private void setupCurrentExtensionContext(String extension) {
        this.currentExtension = (ExtensionModel)this.context.getExtension(extension).orElseThrow(() -> new IllegalArgumentException(String.format("Extension [%s] is not present in the current context. Available extensions are: %s", extension, this.context.getExtensions().stream().map(NamedObject::getName).collect(Collectors.toList()))));
        this.dsl = this.resolvers.get(this.currentExtension);
    }

    private DslElementModel<ConnectionProviderModel> createConnectionProviderModel(ConnectionProviderModel providerModel, ConnectionElementDeclaration connection) {
        DslElementSyntax providerDsl = this.dsl.resolve((NamedObject)providerModel);
        InternalComponentConfiguration.Builder builder = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(providerDsl));
        DslElementModel.Builder<ConnectionProviderModel> element = this.createParameterizedElementModel(providerModel, providerDsl, (ParameterizedElementDeclaration)connection, builder);
        ComponentConfiguration providerConfig = builder.build();
        return element.withConfig(providerConfig).build();
    }

    private void addConnectionProvider(ConnectionElementDeclaration connection, ConfigurationModel model, InternalComponentConfiguration.Builder configuration, DslElementModel.Builder<ConfigurationModel> configElement) {
        Stream.concat(model.getConnectionProviders().stream(), this.currentExtension.getConnectionProviders().stream()).filter(c -> c.getName().equals(connection.getName())).findFirst().ifPresent(provider -> {
            DslElementModel<ConnectionProviderModel> connectionProviderModel = this.createConnectionProviderModel((ConnectionProviderModel)provider, connection);
            connectionProviderModel.getConfiguration().ifPresent(arg_0 -> ((InternalComponentConfiguration.Builder)configuration).withNestedComponent(arg_0));
            configElement.containing(connectionProviderModel);
        });
    }

    private <T extends ParameterizedModel> DslElementModel.Builder<T> createParameterizedElementModel(T model, DslElementSyntax elementDsl, ParameterizedElementDeclaration declaration, InternalComponentConfiguration.Builder parentConfig) {
        DslElementModel.Builder parentElement = DslElementModel.builder().withModel(model).withDsl(elementDsl);
        this.enrichParameterizedElementModel(model, elementDsl, declaration, parentConfig, parentElement);
        return parentElement;
    }

    private <T extends ParameterizedModel> void enrichParameterizedElementModel(T model, DslElementSyntax elementDsl, ParameterizedElementDeclaration declaration, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder<T> parentElement) {
        this.addAllDeclaredParameters(model.getParameterGroupModels(), declaration, elementDsl, parentConfig, parentElement);
        if (model instanceof SourceModel) {
            ((SourceModel)model).getSuccessCallback().ifPresent(cb -> this.addAllDeclaredParameters(cb.getParameterGroupModels(), declaration, elementDsl, parentConfig, parentElement));
            ((SourceModel)model).getErrorCallback().ifPresent(cb -> this.addAllDeclaredParameters(cb.getParameterGroupModels(), declaration, elementDsl, parentConfig, parentElement));
        }
        this.addCustomParameters(declaration, parentConfig, parentElement);
        declaration.getMetadataProperties().forEach((arg_0, arg_1) -> ((InternalComponentConfiguration.Builder)parentConfig).withProperty(arg_0, arg_1));
    }

    private <T extends ParameterizedModel> void addCustomParameters(ParameterizedElementDeclaration declaration, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder<T> parentElement) {
        declaration.getCustomConfigurationParameters().forEach(p -> {
            parentConfig.withParameter(p.getName(), p.getValue().toString());
            parentElement.containing(DslElementModel.builder().withModel((Object)this.typeLoader.load(String.class)).withDsl(DslElementSyntaxBuilder.create().withAttributeName(p.getName()).build()).withValue(p.getValue().toString()).isExplicitInDsl(true).build());
        });
    }

    private void addAllDeclaredParameters(List<ParameterGroupModel> groups, ParameterizedElementDeclaration parameterizedDeclaration, DslElementSyntax parentDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        groups.forEach(group -> {
            Optional groupDeclaration = parameterizedDeclaration.getParameterGroup(group.getName());
            if (groupDeclaration.isPresent()) {
                if (group.isShowInDsl()) {
                    this.addInlineGroupElement((ParameterGroupModel)group, parentDsl, parentConfig, (DslElementModel.Builder)parentElement, groupDeclaration);
                } else {
                    this.addGroupParameterElements((ParameterGroupModel)group, parentDsl, parentConfig, (DslElementModel.Builder)parentElement, groupDeclaration);
                }
            } else if (!ExtensionModelUtils.isRequired((ParameterGroupModel)group) && group.getParameterModels().stream().anyMatch(p -> ExtensionModelUtils.getDefaultValue((ParameterModel)p).isPresent())) {
                if (group.isShowInDsl()) {
                    this.addInlineGroupElement((ParameterGroupModel)group, parentDsl, parentConfig, (DslElementModel.Builder)parentElement, Optional.empty());
                } else {
                    this.addGroupParameterElements((ParameterGroupModel)group, parentDsl, parentConfig, (DslElementModel.Builder)parentElement, Optional.empty());
                }
            }
        });
    }

    private <T> void addGroupParameterElements(ParameterGroupModel group, DslElementSyntax elementDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder<T> parentElement, Optional<ParameterGroupElementDeclaration> declaration) {
        group.getParameterModels().forEach(paramModel -> elementDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> {
            Optional parameterDeclaration;
            boolean declared = false;
            if (declaration.isPresent() && (parameterDeclaration = ((ParameterGroupElementDeclaration)declaration.get()).getParameter(paramModel.getName())).isPresent()) {
                this.addParameter(((ParameterElementDeclaration)parameterDeclaration.get()).getName(), ((ParameterElementDeclaration)parameterDeclaration.get()).getValue(), (ParameterModel)paramModel, (DslElementSyntax)paramDsl, parentConfig, parentElement);
                declared = true;
            }
            if (!declared) {
                ExtensionModelUtils.getDefaultValue((ParameterModel)paramModel).ifPresent(value -> this.createSimpleParameter((ParameterSimpleValue)ParameterSimpleValue.of((String)value), (DslElementSyntax)paramDsl, parentConfig, parentElement, (ParameterModel)paramModel, false));
            }
        }));
    }

    private <T> void addInlineGroupElement(ParameterGroupModel group, DslElementSyntax elementDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder<T> parentElement, Optional<ParameterGroupElementDeclaration> declaration) {
        elementDsl.getChild(group.getName()).ifPresent(groupDsl -> {
            DslElementModel.Builder groupElementBuilder = DslElementModel.builder().withModel((Object)group).withDsl(groupDsl).isExplicitInDsl(declaration.isPresent());
            InternalComponentConfiguration.Builder groupConfigBuilder = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier((DslElementSyntax)groupDsl));
            this.addGroupParameterElements(group, (DslElementSyntax)groupDsl, groupConfigBuilder, (DslElementModel.Builder)groupElementBuilder, declaration);
            ComponentConfiguration groupConfig = groupConfigBuilder.build();
            groupElementBuilder.withConfig(groupConfig);
            parentConfig.withNestedComponent(groupConfig);
            parentElement.containing(groupElementBuilder.build());
        });
    }

    private void addParameter(final String parameterName, ParameterValue value, final ParameterModel parameterModel, final DslElementSyntax paramDsl, final InternalComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        if (ExtensionModelUtils.isInfrastructure((ParameterModel)parameterModel)) {
            this.infrastructureDelegate.addParameter(parameterName, value, parameterModel, paramDsl, parentConfig, parentElement, this.context, this.dsl);
            return;
        }
        value.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(ParameterSimpleValue text) {
                Preconditions.checkArgument((paramDsl.supportsAttributeDeclaration() || ExtensionModelUtils.isContent((ParameterModel)parameterModel) || DeclarationBasedElementModelFactory.this.isText(parameterModel) ? 1 : 0) != 0, (String)("Simple values can only be declared for parameters of simple type, or those with Content role. Invalid declaration for parameter: " + parameterName));
                DeclarationBasedElementModelFactory.this.createSimpleParameter(text, paramDsl, parentConfig, parentElement, parameterModel, true);
            }

            public void visitListValue(ParameterListValue list) {
                Preconditions.checkArgument((boolean)paramDsl.supportsChildDeclaration(), (String)String.format("Inline List values are not allowed for this parameter [%s]", parameterModel.getName()));
                Preconditions.checkArgument((boolean)(parameterModel.getType() instanceof ArrayType), (String)String.format("List values can only be associated to ArrayType parameters. Parameter [%s] is of type [%s]", parameterModel.getName(), ExtensionMetadataTypeUtils.getId((MetadataType)parameterModel.getType())));
                DeclarationBasedElementModelFactory.this.createList(list, paramDsl, parameterModel, (ArrayType)parameterModel.getType(), parentConfig, parentElement);
            }

            public void visitObjectValue(ParameterObjectValue objectValue) {
                Preconditions.checkArgument((boolean)(parameterModel.getType() instanceof ObjectType), (String)String.format("Complex values can only be associated to ObjectType parameters. Parameter [%s] is of type [%s]", parameterModel.getName(), ExtensionMetadataTypeUtils.getId((MetadataType)parameterModel.getType())));
                Preconditions.checkArgument((boolean)paramDsl.supportsChildDeclaration(), (String)String.format("Complex values are not allowed for this parameter [%s]", parameterModel.getName()));
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)parameterModel.getType())) {
                    DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, paramDsl, parameterModel, (ObjectType)parameterModel.getType(), parentConfig, parentElement);
                } else {
                    DeclarationBasedElementModelFactory.this.createComplexParameter(objectValue, paramDsl, parameterModel, parentConfig, parentElement);
                }
            }
        });
    }

    private void createMapParameter(ParameterObjectValue objectValue, DslElementSyntax paramDsl, Object model, ObjectType mapType, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        this.createMapParameter(objectValue, paramDsl, model, mapType, parentConfig, parentElement, this.isParameterWrappedByContainer(model));
    }

    private boolean isParameterWrappedByContainer(Object model) {
        return !(model instanceof ParameterModel) || !((ParameterModel)model).getModelProperty(NoWrapperModelProperty.class).isPresent();
    }

    private void createMapParameter(ParameterObjectValue objectValue, DslElementSyntax paramDsl, Object model, ObjectType mapType, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, boolean isParameterWrappedByContainer) {
        InternalComponentConfiguration.Builder mapConfig = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(paramDsl));
        DslElementModel.Builder mapElement = DslElementModel.builder().withModel(model).withDsl(paramDsl);
        final MetadataType valueType = (MetadataType)mapType.getOpenRestriction().get();
        paramDsl.getGeneric(valueType).ifPresent(entryDsl -> objectValue.getParameters().forEach((key, value) -> {
            final InternalComponentConfiguration.Builder entryConfigBuilder = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier((DslElementSyntax)entryDsl));
            final DslElementModel.Builder entryElement = DslElementModel.builder().withModel((Object)valueType).withDsl(entryDsl);
            entryDsl.getAttribute("key").ifPresent(keyDsl -> {
                entryConfigBuilder.withParameter("key", key);
                entryElement.containing(DslElementModel.builder().withModel((Object)this.typeLoader.load(String.class)).withDsl(keyDsl).withValue(key).build());
            });
            entryDsl.getAttribute("value").ifPresent(valueDsl -> value.accept(new ParameterValueVisitor((DslElementSyntax)valueDsl){
                final /* synthetic */ DslElementSyntax val$valueDsl;
                {
                    this.val$valueDsl = dslElementSyntax;
                }

                public void visitSimpleValue(ParameterSimpleValue text) {
                    entryConfigBuilder.withParameter("value", text.getValue());
                    entryElement.containing(DslElementModel.builder().withModel((Object)valueType).withDsl(this.val$valueDsl).withValue(text.getValue()).build());
                }

                public void visitListValue(ParameterListValue list) {
                    DeclarationBasedElementModelFactory.this.createList(list, this.val$valueDsl, valueType, (ArrayType)valueType, entryConfigBuilder, entryElement);
                }

                public void visitObjectValue(ParameterObjectValue objectValue) {
                    if (ExtensionMetadataTypeUtils.isMap((MetadataType)valueType)) {
                        DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, this.val$valueDsl, valueType, (ObjectType)valueType, entryConfigBuilder, entryElement);
                    } else {
                        DeclarationBasedElementModelFactory.this.createObject(objectValue, this.val$valueDsl, valueType, (ObjectType)valueType, entryConfigBuilder, entryElement);
                    }
                }
            }));
            ComponentConfiguration entryConfig = entryConfigBuilder.build();
            if (isParameterWrappedByContainer) {
                mapConfig.withNestedComponent(entryConfig);
                mapElement.containing(entryElement.withConfig(entryConfig).build());
            } else {
                parentConfig.withNestedComponent(entryConfig);
                parentElement.containing(entryElement.withConfig(entryConfig).build());
            }
        }));
        if (isParameterWrappedByContainer) {
            ComponentConfiguration result = mapConfig.build();
            parentConfig.withNestedComponent(result);
            parentElement.containing(mapElement.withConfig(result).build());
        }
    }

    private void createComplexParameter(ParameterObjectValue objectValue, DslElementSyntax paramDsl, ParameterModel parameterModel, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        if (!paramDsl.isWrapped()) {
            this.createObject(objectValue, paramDsl, parameterModel, (ObjectType)parameterModel.getType(), parentConfig, parentElement);
        } else {
            this.createWrappedObject(objectValue, parameterModel, paramDsl, parentConfig, parentElement);
        }
    }

    private void createWrappedObject(ParameterObjectValue objectValue, ParameterModel parameterModel, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        ObjectType nestedElementType;
        DslElementModel.Builder wrapperElement = DslElementModel.builder().withModel((Object)parameterModel).withDsl(paramDsl);
        InternalComponentConfiguration.Builder wrapperConfig = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(paramDsl));
        Reference customDsl = new Reference((Object)this.dsl);
        if (objectValue.getTypeId() == null || objectValue.getTypeId().trim().isEmpty() || ExtensionMetadataTypeUtils.getId((MetadataType)parameterModel.getType()).map(id -> id.equals(objectValue.getTypeId())).orElse(false).booleanValue()) {
            nestedElementType = (ObjectType)parameterModel.getType();
        } else {
            nestedElementType = this.lookupType(objectValue);
            this.context.getTypeCatalog().getDeclaringExtension(objectValue.getTypeId()).ifPresent(owner -> this.context.getExtension(owner).ifPresent(extensionModel -> {
                DslSyntaxResolver cfr_ignored_0 = (DslSyntaxResolver)customDsl.set((Object)this.resolvers.get(extensionModel));
            }));
        }
        ((DslSyntaxResolver)customDsl.get()).resolve((MetadataType)nestedElementType).ifPresent(typeDsl -> this.createObject(objectValue, (DslElementSyntax)typeDsl, nestedElementType, nestedElementType, wrapperConfig, wrapperElement));
        ComponentConfiguration result = wrapperConfig.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(wrapperElement.withConfig(result).build());
    }

    private void createSimpleParameter(ParameterSimpleValue value, DslElementSyntax paramDsl, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, ParameterModel parameterModel, boolean explicit) {
        if (paramDsl.supportsAttributeDeclaration()) {
            if (parameterModel.isComponentId()) {
                return;
            }
            parentConfig.withParameter(paramDsl.getAttributeName(), value.getValue());
            parentElement.containing(DslElementModel.builder().withModel((Object)parameterModel).withDsl(paramDsl).withValue(value.getValue()).isExplicitInDsl(explicit).build());
        } else {
            ComponentConfiguration parameterConfig = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(paramDsl)).withValue(value.getValue()).withProperty("IS_CDATA", (Object)(value.isCData() ? Boolean.valueOf(true) : null)).build();
            parentConfig.withNestedComponent(parameterConfig);
            parentElement.containing(DslElementModel.builder().withModel((Object)parameterModel).withDsl(paramDsl).withConfig(parameterConfig).isExplicitInDsl(explicit).withValue(value.getValue()).build());
        }
    }

    private ObjectType lookupType(ParameterObjectValue objectValue) {
        ObjectType nestedElementType = (ObjectType)this.context.getTypeCatalog().getType(objectValue.getTypeId()).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find Type with ID '%s' in the current context", objectValue.getTypeId())));
        return nestedElementType;
    }

    private void createListItemConfig(final MetadataType itemValueType, ParameterValue itemValue, final DslElementSyntax itemDsl, final InternalComponentConfiguration.Builder parentConfig, final DslElementModel.Builder parentElement) {
        itemValue.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(ParameterSimpleValue text) {
                itemDsl.getContainedElement("value").ifPresent(valueDsl -> {
                    ComponentConfiguration item = InternalComponentConfiguration.builder().withIdentifier(DeclarationBasedElementModelFactory.this.asIdentifier(itemDsl)).withParameter("value", text.getValue()).build();
                    parentConfig.withNestedComponent(item);
                    parentElement.containing(DslElementModel.builder().withModel((Object)itemValueType).withDsl(itemDsl).withConfig(item).containing(DslElementModel.builder().withModel((Object)itemValueType).withDsl(valueDsl).withValue(text.getValue()).build()).build());
                });
            }

            public void visitListValue(ParameterListValue list) {
                DeclarationBasedElementModelFactory.this.createList(list, itemDsl, itemValueType, (ArrayType)itemValueType, parentConfig, parentElement);
            }

            public void visitObjectValue(final ParameterObjectValue objectValue) {
                itemValueType.accept(new MetadataTypeVisitor(){

                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                            DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, itemDsl, itemValueType, objectType, parentConfig, parentElement);
                        } else {
                            DeclarationBasedElementModelFactory.this.createObject(objectValue, itemDsl, objectType, objectType, parentConfig, parentElement);
                        }
                    }
                });
            }
        });
    }

    private void addObjectField(final MetadataType fieldType, ParameterValue fieldValue, final DslElementSyntax fieldDsl, final InternalComponentConfiguration.Builder objectConfig, final DslElementModel.Builder objectElement) {
        fieldValue.accept(new ParameterValueVisitor(){

            public void visitSimpleValue(ParameterSimpleValue text) {
                if (fieldDsl.supportsAttributeDeclaration()) {
                    objectConfig.withParameter(fieldDsl.getAttributeName(), text.getValue());
                    objectElement.containing(DslElementModel.builder().withModel((Object)fieldType).withDsl(fieldDsl).withValue(text.getValue()).build());
                } else {
                    ComponentConfiguration contentConfiguration = InternalComponentConfiguration.builder().withIdentifier(DeclarationBasedElementModelFactory.this.asIdentifier(fieldDsl)).withValue(text.getValue()).withProperty("IS_CDATA", (Object)(text.isCData() ? Boolean.valueOf(true) : null)).build();
                    objectConfig.withNestedComponent(contentConfiguration);
                    objectElement.containing(DslElementModel.builder().withModel((Object)fieldType).withDsl(fieldDsl).withConfig(contentConfiguration).withValue(text.getValue()).build());
                }
            }

            public void visitListValue(ParameterListValue list) {
                DeclarationBasedElementModelFactory.this.createList(list, fieldDsl, fieldType, (ArrayType)fieldType, objectConfig, objectElement);
            }

            public void visitObjectValue(final ParameterObjectValue objectValue) {
                fieldType.accept(new MetadataTypeVisitor(){

                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                            DeclarationBasedElementModelFactory.this.createMapParameter(objectValue, fieldDsl, fieldType, objectType, objectConfig, objectElement);
                        } else {
                            DeclarationBasedElementModelFactory.this.createObject(objectValue, fieldDsl, objectType, objectType, objectConfig, objectElement);
                        }
                    }
                });
            }
        });
    }

    private void createList(ParameterListValue list, DslElementSyntax listDsl, Object model, ArrayType listType, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        this.createList(list, listDsl, model, listType, parentConfig, parentElement, this.isParameterWrappedByContainer(model));
    }

    private void createList(ParameterListValue list, DslElementSyntax listDsl, Object model, ArrayType listType, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement, boolean isParameterWrappedByContainer) {
        DslElementModel.Builder listElement = DslElementModel.builder().withModel(model).withDsl(listDsl);
        InternalComponentConfiguration.Builder listConfig = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(listDsl));
        MetadataType itemType = listType.getType();
        listDsl.getGeneric(itemType).ifPresent(itemDsl -> list.getValues().forEach(value -> {
            if (isParameterWrappedByContainer) {
                this.createListItemConfig(itemType, (ParameterValue)value, (DslElementSyntax)itemDsl, listConfig, listElement);
            } else {
                this.createListItemConfig(itemType, (ParameterValue)value, (DslElementSyntax)itemDsl, parentConfig, parentElement);
            }
        }));
        if (isParameterWrappedByContainer) {
            ComponentConfiguration result = listConfig.build();
            parentConfig.withNestedComponent(result);
            parentElement.containing(listElement.withConfig(result).build());
        }
    }

    private void createObject(ParameterObjectValue objectValue, DslElementSyntax objectDsl, Object model, ObjectType objectType, InternalComponentConfiguration.Builder parentConfig, DslElementModel.Builder parentElement) {
        InternalComponentConfiguration.Builder objectConfig = InternalComponentConfiguration.builder().withIdentifier(this.asIdentifier(objectDsl));
        DslElementModel.Builder objectElement = DslElementModel.builder().withModel(model).withDsl(objectDsl);
        this.populateObjectElementFields(objectType, objectValue, objectDsl, objectConfig, objectElement);
        ComponentConfiguration result = objectConfig.build();
        parentConfig.withNestedComponent(result);
        parentElement.containing(objectElement.withConfig(result).build());
    }

    private void populateObjectElementFields(ObjectType objectType, ParameterObjectValue objectValue, DslElementSyntax objectDsl, InternalComponentConfiguration.Builder objectConfig, DslElementModel.Builder objectElement) {
        List<ObjectFieldType> fields = objectType.getFields().stream().flatMap(f -> ExtensionMetadataTypeUtils.isFlattenedParameterGroup((MetadataType)f) ? ((ObjectType)f.getValue()).getFields().stream() : Stream.of(f)).collect(Collectors.toList());
        fields.forEach(field -> objectValue.getParameters().entrySet().stream().filter(e -> ExtensionMetadataTypeUtils.getAlias((ObjectFieldType)field).equals(e.getKey())).findFirst().ifPresent(e -> objectDsl.getContainedElement((String)e.getKey()).ifPresent(nestedDsl -> this.addObjectField(field.getValue(), (ParameterValue)e.getValue(), (DslElementSyntax)nestedDsl, objectConfig, objectElement))));
    }

    private ComponentIdentifier asIdentifier(DslElementSyntax fieldDsl) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fieldDsl.getElementName()), (String)String.format("The given component '%s' does not support element-like declaration", fieldDsl.getAttributeName()));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fieldDsl.getPrefix()), (String)String.format("The given component '%s' does not support element-like declaration", fieldDsl.getElementName()));
        return ComponentIdentifier.builder().name(fieldDsl.getElementName()).namespace(fieldDsl.getPrefix()).build();
    }

    private boolean isText(ParameterModel parameter) {
        return parameter.getLayoutModel().map(LayoutModel::isText).orElse(false);
    }
}

