/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.springframework.beans.factory.config.RuntimeBeanReference;

public class PropertyComponentUtils {
    private static final String VALUE_PARAMETER_NAME = "value";
    private static final String PROPERTY_NAME_MULE_PROPERTY_ATTRIBUTE = "key";
    private static final String PROPERTY_NAME_SPRING_PROPERTY_ATTRIBUTE = "name";
    private static final String PROPERTY_NAME_PROPERTY_ATTRIBUTE = "properties";
    private static final String REFERENCE_MULE_PROPERTY_ATTRIBUTE = "value-ref";
    private static final String REFERENCE_SPRING_PROPERTY_ATTRIBUTE = "ref";

    public static Pair<String, Object> getPropertyValueFromPropertyComponent(ComponentAst propertyComponentModel) {
        ComponentParameterAst valueParam;
        String refKey = PropertyComponentUtils.getReferenceAttributeName(propertyComponentModel.getIdentifier());
        String nameKey = PropertyComponentUtils.getNameAttributeName(propertyComponentModel.getIdentifier());
        ComponentParameterAst refKeyParam = propertyComponentModel.getParameter("General", refKey);
        String value = refKeyParam != null ? refKeyParam.getResolvedRawValue() : ((valueParam = propertyComponentModel.getParameter("General", VALUE_PARAMETER_NAME)) != null ? valueParam.getResolvedRawValue() : null);
        String name = propertyComponentModel.getParameter("General", nameKey).getResolvedRawValue();
        if (name != null) {
            return new Pair((Object)name, (Object)value);
        }
        ComponentParameterAst refParam = propertyComponentModel.getParameter("General", REFERENCE_SPRING_PROPERTY_ATTRIBUTE);
        String beanName = refParam != null ? refParam.getResolvedRawValue() : null;
        return new Pair((Object)PROPERTY_NAME_PROPERTY_ATTRIBUTE, (Object)new RuntimeBeanReference(beanName));
    }

    private static String getNameAttributeName(ComponentIdentifier identifier) {
        if (identifier.equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)) {
            return PROPERTY_NAME_MULE_PROPERTY_ATTRIBUTE;
        }
        return PROPERTY_NAME_SPRING_PROPERTY_ATTRIBUTE;
    }

    private static String getReferenceAttributeName(ComponentIdentifier identifier) {
        if (identifier.equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)) {
            return REFERENCE_MULE_PROPERTY_ATTRIBUTE;
        }
        return REFERENCE_SPRING_PROPERTY_ATTRIBUTE;
    }
}

