/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.BaseComponentParameterAstDecorator;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.error.ErrorMapping;

class MacroExpandedComponentAst
extends BaseComponentAstDecorator {
    private final ComponentLocation location;
    private final Set<String> moduleGlobalElementsNames;
    private final String defaultGlobalElementSuffix;
    private final Map<String, String> literalsParameters;
    private final List<ComponentAst> macroExpandedChildren;
    private final Map<String, ComponentParameterAst> mappedParameters = new ConcurrentHashMap<String, ComponentParameterAst>();

    public MacroExpandedComponentAst(ComponentAst original, ComponentLocation location, Set<String> moduleGlobalElementsNames, String defaultGlobalElementSuffix, List<ComponentAst> macroExpandedChildren) {
        this(original, location, moduleGlobalElementsNames, defaultGlobalElementSuffix, Collections.emptyMap(), macroExpandedChildren);
    }

    public MacroExpandedComponentAst(ComponentAst original, ComponentLocation location, Set<String> moduleGlobalElementsNames, String defaultGlobalElementSuffix, Map<String, String> literalsParameters, List<ComponentAst> macroExpandedChildren) {
        super(original);
        this.location = location;
        this.moduleGlobalElementsNames = moduleGlobalElementsNames;
        this.defaultGlobalElementSuffix = defaultGlobalElementSuffix;
        this.literalsParameters = literalsParameters;
        this.macroExpandedChildren = macroExpandedChildren;
    }

    public Stream<ComponentAst> recursiveStream() {
        return Stream.concat(Stream.concat(Stream.of(this), this.getDecorated().directChildrenStream().flatMap(ComponentAst::recursiveStream)), this.directChildrenStream().flatMap(ComponentAst::recursiveStream));
    }

    public Stream<ComponentAst> directChildrenStream() {
        return this.macroExpandedChildren.stream();
    }

    public ComponentParameterAst getParameter(String parameterGroup, String parameterName) {
        ComponentParameterAst parameter = super.getParameter(parameterGroup, parameterName);
        return parameter != null ? this.resolveParameter(parameter) : null;
    }

    private ComponentParameterAst resolveParameter(ComponentParameterAst parameter) {
        String resolvedParameterKey = parameter.getGroupModel() == null ? parameter.getModel().getName() : parameter.getGroupModel().getName() + "-" + parameter.getModel().getName();
        this.mappedParameters.putIfAbsent(resolvedParameterKey, this.mapIdParam(parameter));
        return this.mappedParameters.get(resolvedParameterKey);
    }

    public Collection<ComponentParameterAst> getParameters() {
        return super.getParameters().stream().map(this::resolveParameter).collect(Collectors.toList());
    }

    private ComponentParameterAst mapIdParam(ComponentParameterAst originalParameter) {
        Objects.requireNonNull(originalParameter);
        return new BaseComponentParameterAstDecorator(originalParameter){
            private final LazyValue<Either<String, ?>> expandedParameter;
            {
                this.expandedParameter = new LazyValue(this::expandParameter);
            }

            public <T> Either<String, T> getValue() {
                return (Either)this.expandedParameter.get();
            }

            private <T> Either<String, T> expandParameter() {
                Either originalValue = this.getDecorated().getValue();
                if (originalValue.isLeft()) {
                    String expression = "#[" + (String)originalValue.getLeft() + "]";
                    if (MacroExpandedComponentAst.this.literalsParameters.containsKey(expression)) {
                        return Either.right(MacroExpandedComponentAst.this.literalsParameters.get(expression));
                    }
                    return originalValue;
                }
                return originalValue.mapRight(this::mapParameter);
            }

            private <T> Object mapParameter(T rawValue) {
                if (this.mustMacroExpandRawValue(rawValue)) {
                    return this.macroExpandedRawValue((String)rawValue);
                }
                if (this.isAnErrorMappings()) {
                    return this.mapErrorMappings(this.getDecorated());
                }
                if (this.supportsChildDeclaration() && !this.isResolvedByMetadataVisitor(rawValue)) {
                    return this.macroExpandComplexParameter();
                }
                return rawValue;
            }

            private <T> boolean mustMacroExpandRawValue(T rawValue) {
                return rawValue instanceof String;
            }

            private boolean isAnErrorMappings() {
                return this.getDecorated().getModel().getName().equals("errorMappings");
            }

            private <T> boolean isResolvedByMetadataVisitor(T rawValue) {
                return rawValue instanceof List || rawValue instanceof Map;
            }

            private boolean supportsChildDeclaration() {
                Optional dslElementSyntax = this.getDecorated().getGenerationInformation().getSyntax();
                return dslElementSyntax.map(DslElementSyntax::supportsChildDeclaration).orElse(false);
            }

            private Object mapErrorMappings(ComponentParameterAst originalParameter) {
                return originalParameter.getValue().mapRight(mappings -> ((List)mappings).stream().map(mapping -> new ErrorMapping(MacroExpandedComponentAst.this.literalsParameters.getOrDefault(mapping.getSource(), mapping.getSource()).toString(), MacroExpandedComponentAst.this.literalsParameters.getOrDefault(mapping.getTarget(), mapping.getTarget()).toString())).collect(Collectors.toList())).getRight();
            }

            private Object macroExpandComplexParameter() {
                ComponentAst component = (ComponentAst)this.getDecorated().getValue().getRight();
                MacroExpandedComponentAst macroExpandedComponentAst = new MacroExpandedComponentAst(component, component.getLocation(), MacroExpandedComponentAst.this.moduleGlobalElementsNames, MacroExpandedComponentAst.this.defaultGlobalElementSuffix, MacroExpandedComponentAst.this.literalsParameters, MacroExpandedComponentAst.this.macroExpandedChildren);
                return MuleArtifactAstCopyUtils.copyComponentTreeRecursively((ComponentAst)macroExpandedComponentAst, UnaryOperator.identity());
            }

            public String getRawValue() {
                return this.macroExpandedRawValue(this.getDecorated().getRawValue());
            }

            public String getResolvedRawValue() {
                return this.macroExpandedRawValue(this.getDecorated().getResolvedRawValue());
            }

            private String macroExpandedRawValue(String originalRawValue) {
                if (originalRawValue != null) {
                    if (MacroExpandedComponentAst.this.moduleGlobalElementsNames.contains(originalRawValue)) {
                        return originalRawValue.concat("-").concat(MacroExpandedComponentAst.this.defaultGlobalElementSuffix);
                    }
                    return MacroExpandedComponentAst.this.literalsParameters.getOrDefault(originalRawValue, originalRawValue).toString();
                }
                return null;
            }
        };
    }

    public Optional<String> getComponentId() {
        return super.getComponentId().map(this::mapParamValue);
    }

    private String mapParamValue(String originalValue) {
        if (this.moduleGlobalElementsNames.contains(originalValue)) {
            return originalValue.concat("-").concat(this.defaultGlobalElementSuffix);
        }
        return this.literalsParameters.getOrDefault(originalValue, originalValue).toString();
    }

    public ComponentLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return super.toString() + " - macroExpanded";
    }
}

