/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationProperty;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;

public class EnvironmentPropertiesConfigurationProvider
implements ConfigurationPropertiesProvider {
    private final Map<String, ConfigurationProperty> configurationAttributes = new HashMap<String, ConfigurationProperty>();

    public EnvironmentPropertiesConfigurationProvider() {
        this(System::getenv);
    }

    EnvironmentPropertiesConfigurationProvider(Supplier<Map<String, String>> environmentVariablesSupplier) {
        Map<String, String> environmentVariables = environmentVariablesSupplier.get();
        environmentVariables.entrySet().forEach(entry -> this.configurationAttributes.put((String)entry.getKey(), new DefaultConfigurationProperty("environment variable", (String)entry.getKey(), entry.getValue())));
        Properties properties = System.getProperties();
        Set<Object> keys = properties.keySet();
        keys.stream().forEach(key -> {
            Object value = properties.get(key);
            if (value != null) {
                String stringKey = key instanceof String ? (String)key : key.toString();
                String stringValue = value instanceof String ? (String)value : value.toString();
                this.configurationAttributes.put(stringKey, new DefaultConfigurationProperty("system property", stringKey, stringValue));
            }
        });
    }

    public Optional<ConfigurationProperty> provide(String configurationAttributeKey) {
        return Optional.ofNullable(this.configurationAttributes.get(configurationAttributeKey));
    }

    public String getDescription() {
        return "environment properties provider";
    }
}

